package taberion;

import javax.swing.table.DefaultTableCellRenderer;
import java.awt.Color;
import java.math.BigDecimal;

public class TTableCellRenderer extends DefaultTableCellRenderer
{
    TTableModel myTableModel;
    Color myMaxColor = TConsts.startMaxCol, myMinColor = TConsts.startMinCol; 
    
    public TTableCellRenderer(TTableModel tabMod){
         super();
         myTableModel = tabMod;
    }
    
    public void setValue(Object value)
    {
        setBackground(Color.white);

        String content = value.toString();
        try{
            BigDecimal tmpDec = new BigDecimal(content);
            BigDecimal maxVal = new BigDecimal(getModel().getMaxValue());
            BigDecimal minVal = new BigDecimal(getModel().getMinValue());
//            //System.out.println("Der Float: " + tmpFloat);
            
//            tmpFloat = ((tmpFloat - Float.parseFloat(myTableModel.getMinValue()))/(Float.parseFloat(myTableModel.getMaxValue())-Float.parseFloat(myTableModel.getMinValue())));
            tmpDec = tmpDec.subtract(minVal);
            if (maxVal.subtract(minVal).compareTo(new BigDecimal("0"))==0)
            {
                tmpDec = new BigDecimal(0);
            }else{
                tmpDec = tmpDec.divide(maxVal.subtract(minVal), 5, BigDecimal.ROUND_HALF_UP);
            }
            
            
//            //System.out.println("MaxVal" + myTableModel.getMaxValue() +" - MinVal "+ myTableModel.getMinValue());
//            //System.out.println("Und das Ergebnis: "+tmpFloat);
            setBackground(TColorCreator.getColorFromRange(myMaxColor, myMinColor, tmpDec.floatValue()));
        }catch(NumberFormatException nFE){}

        setText(content);
    }

    public void setModel(TTableModel tableModel)
    {
        myTableModel = tableModel;
    }
    
    public TTableModel getModel()
    {
        return myTableModel;
    }

    public void setColorRange(Color max, Color min)
    {
        myMaxColor = max;
        myMinColor = min;
        repaint();
    }
    
    
}