package taberion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.lang.Math;

    /**
     * Parses Objects to String and the either to String represantions of a Decimal, or of an Integer.
     */
public class TParser
{  
private int myRoundState = BigDecimal.ROUND_HALF_UP;

    public TParser()
    {
        
    }
    
    /**
     * The Object myObj is parsed via toString() into a String representation of an Integer. 
     * After having parsed myObj into an String by .toString(), the String if freed from all characters which cannot be parsed to an Integer.
     * Returns a String which can be parsed directly into an Integer (without any Exception).<br>
     * It does no only accept numbers, but the minus sign as well if it is positioned 
     * ahead all other numbers. Every other minus sign will become deleted.<br>
     * If the Object is not initialised or the parsed String does not contain any characters, 
     * useful for an Integer, "0" is returned.
     * @param myObj The Object which should be made to a String by toString() and then 
     * parsed into an String Representation of an Integer.
     * @return The returned string only contains characters which are useful in an Integer.
     */
    public String clean2Int(Object myObj)
    {
        BigDecimal myBigDec = new BigDecimal(clean2Dec(myObj));
        
        myBigDec = myBigDec.setScale(0, getRoundState());
        
        BigInteger myBigInt = myBigDec.toBigInteger();

        return myBigInt.toString();
    }

//-----------------------------------------------

    /**
     * The Object myObj is parsed via toString() into a String representation of a Decimal.
     * After having parsed myObj into an String by .toString(), the String if freed from all 
     * characters which cannot be parsed to an Decimal.
     * Returns a String which can be parsed directly into a Decimal (without any Exception).
     * It does no only accept numbers, but the minus sign as well if it is positioned 
     * ahead all other numbers. Every other minus sign will become deleted. 
     * Points or commas are handled the same: The first point or comma will be interpreted as
     * an point. Every following will become deleted.
     * If the Object is not initialised or the parsed String does not contain any characters, 
     * useful for a Decimal, "0" is returned.
     * @param myObj The Object which should be made to a String by toString() and then 
     * parsed into an String Representation of an Integer.
     * @return The returned string only contains characters which are useful in a Decimal.
     */
    public String clean2Dec(Object myObj){
        if(myObj!=null){    
            String myStr=myObj.toString().trim();
            
            char[] resultChr=new char[myStr.length()];
            int r = 0;
            int pointCnt=0;
            if (myStr.length()!=0)
            {
                if (myStr.charAt(0)=='-')
                {
                    resultChr[r++]='-';
                }
            }
            for(int k = 0; k<myStr.length(); k++){
                if (Character.isDigit(myStr.charAt(k)))
                {
                    resultChr[r++]=myStr.charAt(k);
                }else if((myStr.charAt(k)=='.'||myStr.charAt(k)==',')&&pointCnt==0){
                    resultChr[r++]='.';
                    pointCnt++;
                }else
                {
//                    System.out.println("Loss of Information / Precision");
                }
            }
            
            if (r!=0){
                return new String(resultChr, 0, r);
            }else
            {
                return new String("0");
            }
        }
        else
        {
            return new String("0");
        }
    }
    
    public void setRoundState(int roundState)
    {
        myRoundState = roundState;
    }
    
    public int getRoundState()
    {
        return myRoundState;
    }
}