package taberion;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;

import java.util.ResourceBundle;

public class TMenuBar extends JMenuBar{
private JMenu submenu;
private int menuItemCounter = 0;
private ResourceBundle myLangBundle;
private ActionListener myActionListener;
private ButtonGroup myGroup;

    public TMenuBar(ActionListener actionListener, ResourceBundle langBundle)
    {
        this.myLangBundle = langBundle;
        this.myActionListener = actionListener;

        JMenu menu;
        JMenuItem menuItem;

        //builds the FIRST MENU
        menu = new JMenu(langBundle.getString("Matrix"));
        menu.setMnemonic(KeyEvent.VK_E);

        this.add(menu);

        menuItem = new JMenuItem(langBundle.getString("NewMatrix"), KeyEvent.VK_N);
        menuItem.setMnemonic(KeyEvent.VK_N);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);

        menuItem = new JMenuItem(langBundle.getString("LoadMatrix"), KeyEvent.VK_L);
        menuItem.setMnemonic(KeyEvent.VK_L);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_L, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);

        menuItem = new JMenuItem(langBundle.getString("SaveMatrix"), KeyEvent.VK_S);
        menuItem.setMnemonic(KeyEvent.VK_S);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);

        menuItem = new JMenuItem(langBundle.getString("StoreMatrix"), KeyEvent.VK_T);
        menuItem.setMnemonic(KeyEvent.VK_T);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);

        submenu = new JMenu(langBundle.getString("RestoreMatrix"));
        submenu.setMnemonic(KeyEvent.VK_R);

        menu.add(submenu);

        //a group of radio button menu items
        menu.addSeparator();

        JMenu submenu2 = new JMenu(langBundle.getString("Options"));
        submenu2.setMnemonic(KeyEvent.VK_O);

        myGroup = new ButtonGroup();
        JRadioButtonMenuItem rbMenuItem;

        rbMenuItem = new JRadioButtonMenuItem(langBundle.getString("Round"));
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(KeyEvent.VK_D);
        rbMenuItem.setActionCommand("Round");
        myGroup.add(rbMenuItem);
        submenu2.add(rbMenuItem);

        rbMenuItem = new JRadioButtonMenuItem(langBundle.getString("Floor"));
        rbMenuItem.setMnemonic(KeyEvent.VK_F);
        rbMenuItem.setActionCommand("Floor");
        myGroup.add(rbMenuItem);
        submenu2.add(rbMenuItem);

        rbMenuItem = new JRadioButtonMenuItem(langBundle.getString("Ceiling"));
        rbMenuItem.setMnemonic(KeyEvent.VK_C);
        rbMenuItem.setActionCommand("Ceiling");
        myGroup.add(rbMenuItem);
        submenu2.add(rbMenuItem);

        menu.add(submenu2);

        //the Open NEW IMAGE MenuItem
/*        menuItem = new JMenuItem(langBundle.getString("OpenImage"), KeyEvent.VK_O);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, ActionEvent.CTRL_MASK));
        menuItem.getAccessibleContext().setAccessibleDescription("This doesn't really do anything");
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);*/

        menu.addSeparator();

        //the EXIT item
        menuItem = new JMenuItem(langBundle.getString("Exit"), KeyEvent.VK_X);
        menuItem.setMnemonic(KeyEvent.VK_X);
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);

        //-- Main Menu Item  VIEW
        menu = new JMenu(langBundle.getString("View"));
        menu.setMnemonic(KeyEvent.VK_V);

        this.add(menu);

        //SHOW MATRIX menu item
        menuItem = new JMenuItem(langBundle.getString("TransposeMatrix"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, ActionEvent.CTRL_MASK));
        menuItem.setMnemonic(KeyEvent.VK_P);
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);

        menu = new JMenu(langBundle.getString("Help"));
        menu.setMnemonic(KeyEvent.VK_H);

        this.add(menu);

        //SHOW MATRIX menu item
        menuItem = new JMenuItem(langBundle.getString("Introduction"));
        //menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
        menuItem.setMnemonic(KeyEvent.VK_I);
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);

        menu.addSeparator();

        menuItem = new JMenuItem(langBundle.getString("About"));
        //menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
        menuItem.setMnemonic(KeyEvent.VK_A);
        menuItem.addActionListener(myActionListener);
        menu.add(menuItem);
    }

    public int addStoredMatrix(String s)
    {
        //System.out.println(menuItemCounter);

        menuItemCounter = menuItemCounter%10;

        JMenuItem menuItem = new JMenuItem(menuItemCounter + " - " + s);

//      KeyEvent.VK_1 has the value 49,
//      and because of that, I'm using 48 and add the current ComponentCount
        menuItem.setMnemonic(48+menuItemCounter);
        menuItem.addActionListener(myActionListener);

        if (submenu.getMenuComponentCount() > menuItemCounter)
        {
            submenu.remove(menuItemCounter);
        }

        submenu.add(menuItem, menuItemCounter);

        menuItemCounter++;

        return menuItemCounter-1;
    }

    public int getRoundState()
    {
        String actComm = myGroup.getSelection().getActionCommand();

        if(actComm == "Ceiling")
        {
            return BigDecimal.ROUND_CEILING;
        }
        else if(actComm == "Floor")
        {
            return BigDecimal.ROUND_FLOOR;
        }
        else
        {
            return BigDecimal.ROUND_HALF_UP;
        }
    }
}