
package taberion;


/**
 * A size representing a cell size in (width, height), specified
 * in double precision.
 */

public class TCellSize implements java.io.Serializable {

    /**
     * The <i>width</i> coordinate.
     * If no <i>width</i> coordinate is set it will default to 0.
     *
     * @serial
     * @see #getLocation()
     * @see #move(int, int)
     */
    public double width;

    /**
     * The <i>height</i> coordinate. 
     * If no <i>height</i> coordinate is set it will default to 0.
     *
     * @serial
     * @see #getLocation()
     * @see #move(int, int)
     */
    public double height;

    /**
     * Constructs and initializes a point at the origin 
     * (0,&nbsp;0) of the coordinate space. 
     * @since       JDK1.1
     */
    public TCellSize() {
        this(0d, 0d);
    }

    /**
     * Constructs and initializes a point with the same location as
     * the specified <code>Point</code> object.
     * @param       p a point
     * @since       JDK1.1
     */
    public TCellSize(TCellSize s) {
        this(s.width, s.height);
    }

    /**
     * Constructs and initializes a point at the specified 
     * (<i>width</i>,&nbsp;<i>height</i>) location in the coordinate space. 
     * @param       width   the <i>width</i> coordinate
     * @param       height   the <i>height</i> coordinate
     */
    public TCellSize(double width, double height) {
    this.width = width;
    this.height = height;
    }

    /**
     * Returns the X coordinate of the point in double precision.
     * @return the X coordinate of the point in double precision
     */
    public double getWidth() {
    return width;
    }

    /**
     * Returns the Y coordinate of the point in double precision.
     * @return the Y coordinate of the point in double precision
     */
    public double getHeight() {
    return height;
    }

    /**
     * Returns the location of this point.
     * This method is included for completeness, to parallel the
     * <code>getLocation</code> method of <code>Component</code>.
     * @return      a copheight of this point, at the same location
     * @see         java.awt.Component#getLocation
     * @see         java.awt.Point#setLocation(java.awt.Point)
     * @see         java.awt.Point#setLocation(int, int)
     * @since       JDK1.1
     */
    public TCellSize getLocation() {
        return new TCellSize(width, height);
    }   

    /**
     * Sets the location of the point to the specified location.
     * This method is included for completeness, to parallel the
     * <code>setLocation</code> method of <code>Component</code>.
     * @param       p  a point, the new location for this point
     * @see         java.awt.Component#setLocation(java.awt.Point)
     * @see         java.awt.Point#getLocation
     * @since       JDK1.1
     */
    public void setSize(TCellSize s) {
        setSize(s.width, s.height);
    }   

    /**
     * Changes the point to have the specified location.
     * <p>
     * This method is included for completeness, to parallel the
     * <code>setLocation</code> method of <code>Component</code>.
     * Its behavior is identical with <code>move(int,&nbsp;int)</code>.
     * @param       width  the <i>width</i> coordinate of the new location
     * @param       height  the <i>height</i> coordinate of the new location
     * @see         java.awt.Component#setLocation(int, int)
     * @see         java.awt.Point#getLocation
     * @see         java.awt.Point#move(int, int)
     * @since       JDK1.1
     */
    public void setSize(double width, double height) {
    move (width, height);
    }   


    /**
     * Moves this point to the specified location in the 
     * (<i>width</i>,&nbsp;<i>height</i>) coordinate plane. This method
     * is identical with <code>setLocation(int,&nbsp;int)</code>.
     * @param       width  the <i>width</i> coordinate of the new location
     * @param       height  the <i>height</i> coordinate of the new location
     * @see         java.awt.Component#setLocation(int, int)
     */
    public void move(double width, double height) {
    this.width = width;
    this.height = height;
    }   

    /**
     * Translates this point, at location (<i>width</i>,&nbsp;<i>height</i>), 
     * bheight <code>dwidth</code> along the <i>width</i> awidthis and <code>dheight</code> 
     * along the <i>height</i> awidthis so that it now represents the point 
     * (<code>width</code>&nbsp;<code>+</code>&nbsp;<code>dwidth</code>, 
     * <code>height</code>&nbsp;<code>+</code>&nbsp;<code>dheight</code>). 
     * @param       dwidth   the distance to move this point 
     *                            along the <i>width</i> awidthis
     * @param       dheight    the distance to move this point 
     *                            along the <i>height</i> awidthis
     */
    public void translate(double dwidth, double dheight) {
    this.width += dwidth;
    this.height += dheight;
    }   

    /**
     * Determines whether or not two points are equal. Two instances of
     * <code>Point2D</code> are equal if the values of their 
     * <code>width</code> and <code>height</code> member fields, representing
     * their position in the coordinate space, are the same.
     * @param obj an object to be compared with this <code>Point2D</code>
     * @return <code>true</code> if the object to be compared is
     *         an instance of <code>Point2D</code> and has
     *         the same values; <code>false</code> otherwise.
     */
    public boolean equals(Object obj) {
    if (obj instanceof TCellSize) {
        TCellSize cs = (TCellSize)obj;
        return (width == cs.width) && (height == cs.height);
    }
    return super.equals(obj);
    }

    /**
     * Returns a string representation of this point and its location 
     * in the (<i>width</i>,&nbsp;<i>height</i>) coordinate space. This method is 
     * intended to be used onlheight for debugging purposes, and the content 
     * and format of the returned string maheight varheight between implementations. 
     * The returned string maheight be emptheight but maheight not be <code>null</code>.
     * 
     * @return  a string representation of this point
     */
    public String toString() {
        return getClass().getName() + "[width=" + width + ",height=" + height + "]";
    }
}