package trisentis;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import java.util.ResourceBundle;

public class TSolveThread extends Thread implements ActionListener, WindowListener{
private Trisentis myTrisentis;
private JDialog solveDialog;
private int boardSize;
private int i;
private int[][][] solvMatrix;
private ResourceBundle langBundle;
private boolean stepByStep;
private Point dialogPos;

    public TSolveThread(int boardSize, Trisentis myTrisentis, ResourceBundle langBundle){
            dialogPos=new Point(myTrisentis.getLocation());
            dialogPos.x=(dialogPos.x+50);
            dialogPos.y=(dialogPos.y+50);
            this.langBundle=langBundle;
            solveDialog = new JDialog();
            solveDialog.setTitle(langBundle.getString("SolveTitle"));
            solveDialog.setModal(true);
            this.boardSize=boardSize;
            this.myTrisentis=myTrisentis;
            int i=0;
            solvMatrix = new int[][][]{
            {{1, 1}, {1, 3}, {2, 2}, {3, 2}, {4, 1}, {4, 3}},  //4x4 Feld
            
            {{-1, -1}},  //5x5 Feld
            
            //Def: Ein Feld, das als ersten Punkt (-1, -1) hat, ist unlsbar
            
            {{1, 1}, {2, 2}, {2, 3}, {3, 2}, {2, 4}, {4, 2}, {1, 6}, {2, 5}, {5, 2}, 
             {6, 1}, {3, 5}, {5, 3}, {4, 5}, {5, 4}, {5, 5}, {6, 6}},  //6x6 Feld  
            
            {{-1,-1}}, //7x7 Feld
            
            {{1, 2}, {2, 1}, {1, 3}, {2, 2}, {3, 1}, {2, 4}, {3, 3}, {4, 2}, {1, 6}, 
             {2, 5}, {5, 2}, {6, 1}, {1, 7}, {7, 1}, {2, 7}, {3, 6}, {6, 3}, {7, 2},
             {2, 8}, {8, 2}, {3, 8}, {4, 7}, {7, 4}, {8, 3}, {5, 7}, {6, 6}, {7, 5}, 
             {6, 8}, {7, 7}, {8, 6}, {7, 8}, {8, 7}}, //8x8 Feld
            
            {{-1, -1}}, //9x9 Feld
            
            {{1, 1}, {1, 3}, {2, 2}, {3, 1}, {1, 4}, {4, 1}, {1, 5}, {2, 4}, {4, 2}, 
             {5, 1}, {1, 6}, {3, 4}, {4, 3}, {6, 1}, {1, 7}, {3, 5}, {5, 3}, {7, 1}, 
             {1,8}, {2, 7}, {3, 6}, {6, 3}, {7, 2}, {8, 1}, {3, 7}, {5, 5}, {7, 3}, 
             {1, 10}, {2, 9}, {5, 6}, {6, 5}, {9, 2}, {10, 1}, {4, 8}, {6, 6}, {8, 4}, 
             {3, 10}, {4, 9}, {5, 8}, {8, 5}, {9, 4}, {10, 3}, {4, 10}, {6, 8}, {8, 6}, 
             {10,4}, {5, 10}, {7, 8}, {8, 7}, {10, 5}, {6, 10}, {7, 9}, {9, 7}, {10, 6}, 
             {7, 10}, {10, 7}, {8, 10}, {9, 9}, {10, 8}, {10, 10}}, //10x10 Feld
            
            {{-1, -1}}, //11x11 Feld
            
            {{1, 2}, {2, 1}, {2, 2}, {2, 3}, {3, 2}, {1, 5}, {3, 3}, {5, 1}, {1, 6},
             {2, 5}, {3, 4}, {4, 3}, {5, 2}, {6, 1}, {1, 7}, {2, 6}, {6, 2}, {7, 1},
             {1, 8}, {2, 7}, {3, 6}, {4, 5}, {5, 4}, {6, 3}, {7, 2}, {8, 1}, {2, 8},
             {3, 7}, {7, 3}, {8, 2}, {1, 11}, {2, 10}, {3, 9}, {4, 8}, {6, 6},
             {8, 4}, {9, 3}, {10, 2}, {11, 1}, {2, 11}, {3, 10}, {6, 7}, {7, 6},
             {10, 3}, {11, 2}, {2, 12}, {3, 11}, {4, 10}, {5, 9}, {7, 7}, {9, 5},
             {10, 4}, {11, 3}, {12, 2}, {5, 11}, {6, 10}, {10, 6}, {11, 5}, {5, 12},
             {6, 11}, {7, 10}, {8, 9}, {9, 8}, {10, 7}, {11, 6}, {12, 5}, {6, 12},
             {7, 11}, {11, 7}, {12, 6}, {7, 12}, {8, 11}, {9, 10}, {10, 9}, {11, 8},
             {12, 7}, {8, 12}, {10, 10}, {12, 8}, {10, 11}, {11, 10}, {11, 11},
             {11, 12}, {12, 11}}, //12x12 Feld
            
            {{-1, -1}}, //13x13 Feld
            
            {{1, 1}, {1, 2}, {1, 4}, {3, 2}, {2, 4}, {1, 6}, {3, 4}, {4, 3}, {1, 7}, 
             {3, 5}, {4, 4}, {5, 3}, {6, 2}, {7, 1}, {4, 5}, {5, 4}, {7, 2}, {8, 1}, 
             {4, 6}, {5, 5}, {6, 4}, {3, 8}, {5, 6}, {6, 5}, {9, 2}, {2, 10}, {3, 9}, 
             {4, 8}, {5, 7}, {7, 5}, {9, 3}, {10, 2}, {1, 12}, {4, 9}, {11, 2}, {1, 13}, 
             {2, 12}, {4, 10}, {5, 9}, {8, 6}, {9, 5}, {10, 4}, {12, 2}, {13, 1}, {1, 14}, 
             {2, 13}, {4, 11}, {6, 9}, {7, 8}, {12, 3}, {2, 14}, {4, 12}, {5, 11}, 
             {6, 10}, {7, 9}, {8, 8}, {9, 7}, {10, 6}, {11, 5}, {4, 13}, {7, 10}, {9, 8},
             {10, 7}, {11, 6}, {13, 4}, {6, 12}, {9, 9}, {7, 12}, {9, 10}, {10, 9}, 
             {11, 8}, {7, 13}, {8, 12}, {9, 11}, {10, 10}, {11, 9}, {12, 8}, {13, 7}, 
             {10, 11}, {11, 10}, {12, 9}, {13, 8}, {10, 12}, {12, 10}, {14, 8}, {10, 13}, 
             {12, 11}, {13, 10}, {14, 9}, {12, 12}, {13, 12}, {14, 11}, {13, 13}, 
             {14, 12}},    //14x14 Feld
            
            {{-1, -1}}, //15x15 Feld
            
            {{1, 1}, {1, 3}, {2, 2}, {3, 2}, {4, 1}, {1, 5}, {2, 5}, {4, 3}, {1, 7}, 
             {7, 1}, {4, 5}, {6, 3}, {1, 9}, {2, 8}, {4, 6}, {5, 5}, {6, 4}, {7, 3}, 
             {8, 2}, {3, 8}, {5, 6}, {7, 4}, {8, 3}, {9, 2}, {10, 1}, {1, 11}, {6, 6}, 
             {7, 5}, {9, 3}, {2, 11}, {6, 7}, {7, 6}, {10, 3}, {1, 13}, {4, 10}, {6, 8}, 
             {8, 6}, {10, 4}, {11, 3}, {13, 1}, {4, 11}, {5, 10}, {6, 9}, {7, 8}, {8, 7}, 
             {9, 6}, {10, 5}, {11, 4}, {1, 15}, {2, 14}, {5, 11}, {6, 10}, {9, 7}, 
             {10, 6}, {13, 3}, {14, 2}, {3, 14}, {4, 13}, {7, 10}, {8, 9}, {11, 6}, 
             {12, 5}, {15, 2}, {16, 1}, {6, 12}, {7, 11}, {8, 10}, {9, 9}, {10, 8}, {11, 7},
             {12, 6}, {13, 5}, {4, 15}, {6, 13}, {7, 12}, {9, 10}, {11, 8}, {13, 6}, 
             {16, 3}, {7, 13}, {10, 10}, {11, 9}, {15, 5}, {8, 13}, {10, 11}, {11, 10}, 
             {16, 5}, {7, 15}, {8, 14}, {9, 13}, {10, 12}, {12, 10}, {14, 8}, {9, 14}, 
             {10, 13}, {11, 12}, {12, 11}, {13, 10}, {15, 8}, {16, 7}, {11, 13}, 
             {13, 11}, {10, 15}, {16, 9}, {13, 13}, {15, 11}, {16, 11}, {13, 15}, {14, 14}, 
             {15, 14}, {16, 13}, {16, 15}},  //16x16 Feld
            
            {{-1, -1}}, //17x17 Feld
            
            {{1, 1}, {1, 2}, {2, 1}, {2, 2}, {2, 4}, {4, 2}, {3, 5}, {5, 3}, {2, 7}, 
             {3, 6}, {4, 5}, {5, 4}, {6, 3}, {7, 2}, {1, 9}, {5, 5}, {9, 1}, {1, 10}, 
             {2, 9}, {5, 6}, {6, 5}, {9, 2}, {10, 1}, {2, 10}, {4, 8}, {6, 6}, {8, 4}, 
             {10, 2}, {6, 7}, {7, 6}, {2, 12}, {5, 9}, {6, 8}, {8, 6}, {9, 5}, {12, 2}, 
             {4, 11}, {5, 10}, {6, 9}, {7, 8}, {8, 7}, {9, 6}, {10, 5}, {11, 4}, {3, 13},
             {6, 10}, {7, 9}, {9, 7}, {10, 6}, {13, 3}, {2, 15}, {3, 14}, {6, 11}, 
             {7, 10}, {10, 7}, {11, 6}, {14, 3}, {15, 2}, {1, 17}, {4, 14}, {5, 13}, 
             {6, 12}, {7, 11}, {9, 9}, {11, 7}, {12, 6}, {13, 5}, {14, 4}, {17, 1}, {1, 18}, 
             {2, 17}, {5, 14}, {6, 13}, {9, 10}, {10, 9}, {13, 6}, {14, 5}, {17, 2}, 
             {18, 1}, {2, 18}, {5, 15}, {6, 14}, {7, 13}, {8, 12}, {10, 10}, {12, 8}, 
             {13, 7}, {14, 6}, {15, 5}, {18, 2}, {4, 17}, {5, 16}, {8, 13}, {9, 12}, 
             {12, 9}, {13, 8}, {16, 5}, {17, 4}, {6, 16}, {9, 13}, {10, 12}, {12, 10}, 
             {13, 9}, {16, 6}, {8, 15}, {9, 14}, {10, 13}, {11, 12}, {12, 11}, {13, 10}, 
             {14, 9}, {15, 8}, {7, 17}, {10, 14}, {11, 13}, {13, 11}, {14, 10}, {17, 7},
             {12, 13}, {13, 12}, {9, 17}, {11, 15}, {13, 13}, {15, 11}, {17, 9}, 
             {9, 18}, {10, 17}, {13, 14}, {14, 13}, {17, 10}, {18, 9}, {10, 18}, {14, 14}, 
             {18, 10}, {12, 17}, {13, 16}, {14, 15}, {15, 14}, {16, 13}, {17, 12}, 
             {14, 16}, {16, 14}, {15, 17}, {17, 15}, {17, 17}, {17, 18}, {18, 17}, {18, 18}}, //18x18 Feld
            
            {{-1, -1}}, //19x19 Feld
            
            {{1, 2}, {2, 1}, {2, 2}, {2, 3}, {3, 2}, {3, 3}, {3, 4}, {4, 3}, {2, 6}, 
             {6, 2}, {1, 8}, {3, 6}, {6, 3}, {8, 1}, {2, 8}, {8, 2}, {1, 10}, {3, 8}, 
             {5, 6}, {6, 5}, {8, 3}, {10, 1}, {1, 11}, {3, 9}, {4, 8}, {5, 7}, {6, 6}, 
             {7, 5}, {8, 4}, {9, 3}, {11, 1}, {1, 13}, {7, 7}, {13, 1}, {2, 13}, {3, 12},
             {6, 9}, {7, 8}, {8, 7}, {9, 6}, {12, 3}, {13, 2}, {3, 13}, {6, 10}, 
             {7, 9}, {9, 7}, {10, 6}, {13, 3}, {2, 15}, {4, 13}, {6, 11}, {8, 9}, {9, 8}, 
             {11, 6}, {13, 4}, {15, 2}, {3, 15}, {6, 12}, {8, 10}, {10, 8}, {12, 6}, 
             {15, 3}, {5, 14}, {7, 12}, {8, 11}, {9, 10}, {10, 9}, {11, 8}, {12, 7}, 
             {14, 5}, {1, 19}, {2, 18}, {3, 17}, {5, 15}, {7, 13}, {8, 12}, {9, 11}, {10, 10}, 
             {11, 9}, {12, 8}, {13, 7}, {15, 5}, {17, 3}, {18, 2}, {19, 1}, {2, 19}, 
             {3, 18}, {6, 15}, {7, 14}, {10, 11}, {11, 10}, {14, 7}, {15, 6}, {18, 3}, 
             {19, 2}, {2, 20}, {3, 19}, {4, 18}, {6, 16}, {8, 14}, {9, 13}, {10, 12}, 
             {11, 11}, {12, 10}, {13, 9}, {14, 8}, {16, 6}, {18, 4}, {19, 3}, {20, 2}, 
             {7, 16}, {9, 14}, {10, 13}, {11, 12}, {12, 11}, {13, 10}, {14, 9}, {16, 7},
             {6, 18}, {9, 15}, {11, 13}, {13, 11}, {15, 9}, {18, 6}, {6, 19}, {8, 17},
             {10, 15}, {12, 13}, {13, 12}, {15, 10}, {17, 8}, {19, 6}, {8, 18}, 
             {11, 15}, {12, 14}, {14, 12}, {15, 11}, {18, 8}, {8, 19}, {9, 18}, {12, 15}, 
             {13, 14}, {14, 13}, {15, 12}, {18, 9}, {19, 8}, {8, 20}, {14, 14}, {20, 8}, 
             {10, 20}, {12, 18}, {13, 17}, {14, 16}, {15, 15}, {16, 14}, {17, 13}, 
             {18, 12}, {20, 10}, {11, 20}, {13, 18}, {15, 16}, {16, 15}, {18, 13}, {20, 11},
             {13, 19}, {19, 13}, {13, 20}, {15, 18}, {18, 15}, {20, 13}, {15, 19}, 
             {19, 15}, {17, 18}, {18, 17}, {18, 18}, {18, 19}, {19, 18}, {19, 19}, 
             {19, 20}, {20, 19}}  //20x20 Feld
        };
            
    }
    
    public void run()
    {
//        dialogPos = new Point(500, 500);
        constDialog();
        stepByStep=true;
        while (!isReady())
        {
            myTrisentis.fieldPressed(solvMatrix[boardSize-4][i][1]-1, solvMatrix[boardSize-4][i][0]-1);
            i++;
            if(!stepByStep){
                try{
                  Thread.sleep(200);        
                }catch(InterruptedException iE){}
            }    
            if (stepByStep&&(!isReady())){
                Object[] options = {langBundle.getString("SolveYes"), langBundle.getString("SolveNo")};

                solveDialog.setLocation(dialogPos);
                solveDialog.setVisible(true);
            }
        }
        myTrisentis.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        myTrisentis.setButtonsEnabled(true);
    }

    public void setBoardSize(int boardSize)
    {
       this.boardSize=boardSize; 
    }
    
    public void setTrisentis(Trisentis myTrisentis)
    {
        this.myTrisentis=myTrisentis;
    }
    
    public boolean isReady()
    {
        return (i>=solvMatrix[boardSize-4].length);
    }
    
    public void setReady(boolean isItReady)
    {
        if(isItReady){
            i=solvMatrix[boardSize-4].length;
        }else{
            i=0;
        }    
    }
    
    private void constDialog()
    {
        solveDialog.addWindowListener(this);
        
        JPanel myPanel = new JPanel(new GridLayout(2, 1));
        
        myPanel.add(new JLabel(langBundle.getString("SolveText")));
        
        JPanel mySecPan = new JPanel(new FlowLayout(FlowLayout.CENTER));
        JButton tempBtn = new JButton(langBundle.getString("SolveYes"));
        tempBtn.addActionListener(this);
        mySecPan.add(tempBtn);
        tempBtn = new JButton(langBundle.getString("SolveNo"));
        tempBtn.addActionListener(this);
        mySecPan.add(tempBtn);
        myPanel.add(mySecPan);
        
        solveDialog.getContentPane().add(myPanel);
        
        solveDialog.pack();
        solveDialog.setResizable(false);
        
    }
    
    public void actionPerformed(ActionEvent actEvt)
    {
        String commAnd = actEvt.getActionCommand();
        
        if (commAnd==langBundle.getString("SolveYes"))
        {
            stepByStep=false;
            solveDialog.setVisible(false);
            
        }else if (commAnd==langBundle.getString("SolveNo")) 
        {
            dialogPos=solveDialog.getLocationOnScreen();
            solveDialog.setVisible(false);
        }
    }
            
    public void windowClosing(WindowEvent e) 
    {
        solveDialog.setVisible(false);
        this.setReady(true);
    }
    
    public void windowOpened(WindowEvent e){}
    
    public void windowIconified(WindowEvent e){}
    
    public void windowDeiconified(WindowEvent e){}
    
    public void windowDeactivated(WindowEvent e){}
    
    public void windowActivated(WindowEvent e){}
    
    public void windowClosed(WindowEvent e){}
}