package trisentis;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import java.util.ResourceBundle;

public class TMenuBar extends JMenuBar{
private ImageIcon btnImageIcon;
private ResourceBundle langBundle;
private JCheckBoxMenuItem cbMenuItem;
private JMenu gameMenu, viewMenu, helpMenu;

    public TMenuBar(ActionListener myActionListener, ResourceBundle langBundle)
    {
        this.langBundle=langBundle;
        
        JMenu submenu;
        JMenuItem menuItem;
        
        //builds the FIRST MENU
        gameMenu = new JMenu(langBundle.getString("Game"));
        gameMenu.setMnemonic(KeyEvent.VK_G);
        this.add(gameMenu);
        
        menuItem = new JMenuItem(langBundle.getString("NewGame"), KeyEvent.VK_N);
        menuItem.setMnemonic(KeyEvent.VK_N);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        gameMenu.add(menuItem);
        
        menuItem = new JMenuItem(langBundle.getString("SolveGame"), KeyEvent.VK_S);
        menuItem.setMnemonic(KeyEvent.VK_S);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        gameMenu.add(menuItem);
        
        submenu = new JMenu(langBundle.getString("BoardSize"));
        submenu.setMnemonic(KeyEvent.VK_B);
        
        for(int i=4; i<=20; i++){
        menuItem = new JMenuItem(i+"x"+i);
        menuItem.addActionListener(myActionListener);
        submenu.add(menuItem);
        }
        
        gameMenu.add(submenu);
        
        //a separator
        gameMenu.addSeparator();
        
        //the FIRST example IMAGE
        menuItem = new JMenuItem(langBundle.getString("1Image"), KeyEvent.VK_1);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        menuItem.setMnemonic(KeyEvent.VK_1);
        gameMenu.add(menuItem);
        
        //the SECOND example IMAGE
        menuItem = new JMenuItem(langBundle.getString("2Image"), KeyEvent.VK_2);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_2, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        menuItem.setMnemonic(KeyEvent.VK_2);
        gameMenu.add(menuItem);
        
        //the THIRD example IMAGE
        menuItem = new JMenuItem(langBundle.getString("3Image"), KeyEvent.VK_3);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_3, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        menuItem.setMnemonic(KeyEvent.VK_3);
        gameMenu.add(menuItem);
        
        //the FOURTH example IMAGE
        menuItem = new JMenuItem(langBundle.getString("4Image"), KeyEvent.VK_4);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_4, ActionEvent.CTRL_MASK));
        menuItem.addActionListener(myActionListener);
        menuItem.setMnemonic(KeyEvent.VK_4);
        gameMenu.add(menuItem);
        
        gameMenu.addSeparator();
        
        //the EXIT item
        menuItem = new JMenuItem(langBundle.getString("Exit"), KeyEvent.VK_X);
        menuItem.setMnemonic(KeyEvent.VK_X);
        menuItem.addActionListener(myActionListener);
        gameMenu.add(menuItem);
        
        //-- Main Menu Item  VIEW
        viewMenu = new JMenu(langBundle.getString("View"));
        viewMenu.setMnemonic(KeyEvent.VK_V);
        
        
        //SHOW MATRIX menu item
        cbMenuItem = new JCheckBoxMenuItem(langBundle.getString("ShowMathFrame"));
        cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_M, ActionEvent.CTRL_MASK));
        cbMenuItem.setMnemonic(KeyEvent.VK_M);
        cbMenuItem.addActionListener(myActionListener);
        viewMenu.add(cbMenuItem);
        this.add(viewMenu);
        
        //SHOW HELP menu item
        helpMenu = new JMenu(langBundle.getString("Help"));
        helpMenu.setMnemonic(KeyEvent.VK_H);
        
        menuItem = new JMenuItem(langBundle.getString("Introduction"));
        //menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
        menuItem.setMnemonic(KeyEvent.VK_I);
        menuItem.addActionListener(myActionListener);
        helpMenu.add(menuItem);
        
        helpMenu.addSeparator();
        
        menuItem = new JMenuItem(langBundle.getString("About"));
        //menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
        menuItem.setMnemonic(KeyEvent.VK_A);
        menuItem.addActionListener(myActionListener);
        helpMenu.add(menuItem);
        
        this.add(helpMenu);
    }

    public void setLangBundle(ResourceBundle langBundle) {
        this.langBundle = langBundle; 
    }

    public ResourceBundle getLangBundle() {
        return (this.langBundle); 
    }

//  useful, if the MATH FRAME is CLOSED by DECORATION to update the CheckBox   
    public void setCheckBoxMenuItemSelected(boolean yesOrNo)
    {
        cbMenuItem.setSelected(yesOrNo);
    }
    
    public void setActivated(boolean isActivated)
    {
        gameMenu.setEnabled(isActivated);
        viewMenu.setEnabled(isActivated);
        helpMenu.setEnabled(isActivated);
    }
}