package trisentis;

import java.awt.Image;

import java.awt.image.ImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.CropImageFilter;

import javax.swing.ImageIcon;
import javax.swing.JLabel;


public class TImageLabel extends JLabel{
private ImageIcon btnImageIcon;

    public TImageLabel()
    {
    }
    
    public TImageLabel(String text)
    {
        super(text);
    }
    
    public void setIcon(Image myImage, int buttonWidth, int buttonHeight, int x, int y)
    {
//        System.out.println("TImageLabel: Cropping and adding Image for Button "+x+", "+y);
        ImageFilter cropFilter = new CropImageFilter(
            buttonWidth*x,
            buttonHeight*y,
            buttonWidth, 
            buttonHeight);
            
        Image myImg = createImage(new FilteredImageSource(myImage.getSource(), cropFilter));
        btnImageIcon = new ImageIcon(myImg);
        super.setIcon(btnImageIcon);
    } 
    
    public Image getImage()
    {
         return this.btnImageIcon.getImage();   
    }
    
    public void setIconVisible(boolean b)
    {
        if (b)
        {
            this.setIcon(btnImageIcon);
        }else
        {
            this.setIcon(null);
        }
    }
}