package trisentis;

import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JLabel;
import java.awt.BorderLayout;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Container;

import java.awt.Dimension;

import java.net.URL;

public  class THelpFrame extends JFrame{

private URL codeBase;
    
    public THelpFrame(ResourceBundle langBundle, URL codebase ){
        codeBase = codebase;
        String BUTTONPANEL = langBundle.getString("HowToPlay");
        String TEXTPANEL = langBundle.getString("HowToOperate");
        Container contentPane = getContentPane();

        JTabbedPane tabbedPane = new JTabbedPane();

        JPanel panelGame = new JPanel();
        
        JScrollPane helpGameScrollPane = createScrollPane(langBundle.getString("helpGame.html"));
        panelGame.add(helpGameScrollPane);
        tabbedPane.addTab(BUTTONPANEL, panelGame);

        JScrollPane helpAppScrollPane = createScrollPane(langBundle.getString("helpApp.html"));
        JPanel panelApp = new JPanel();
        panelApp.add(helpAppScrollPane);
        tabbedPane.addTab(TEXTPANEL, panelApp);

        contentPane.add(tabbedPane, BorderLayout.CENTER);
        
        this.setContentPane(contentPane);
        this.pack();
        this.setResizable(false);
        this.setTitle(langBundle.getString("HelpTitle"));
    }
    
    private JScrollPane createScrollPane(String fileName) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        String s = null;
        try {
            URL helpURL = new URL(codeBase.toString()+fileName);
            editorPane.setPage(helpURL);
        } catch (Exception e) {
            System.err.println("Couldn't create help URL: " + s);
        }
        
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        editorScrollPane.setPreferredSize(new Dimension(450, 450));

        return editorScrollPane;
    }

    protected Component createTextPanel(String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(JLabel.CENTER);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(filler);
        return panel;
    }
}