/*
 * Created on 26.06.2003
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.UIManager;


/**
 * Just a very very simple tool that demonstrates the callback functionality
 * between MuPAD and JNI.
 * @author maas
 */
public class SimpleCalculator implements ActionListener {
  JFrame     mainFrame;
  JPanel     mainPanel;
  JTextField queryField;
  JLabel     questionLabel;
  JLabel     answerLabel;
  JButton    calcButton;
  JButton    returnButton;

	/* This line has to be added to every class that wants to communicate to MuPAD!!! */
	public native static String calcMuPAD(String query);

	/**
	 * Centers the window on screen.
	 */
	public static void center(Frame window)
	{
		if (window == null)
		{
			return;
		}
		Rectangle rect = window.getBounds();
		int width = rect.width;
		int height = rect.height;
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		window.setLocation((screenSize.width / 2) - (width / 2),
			(screenSize.height / 2) - (height / 2));
	}

  // Constructor
  public SimpleCalculator() {
    // Create the frame and container.
    mainFrame = new JFrame("Very simple MuPAD-Shell");
    mainFrame.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent e) {
          // DO UNDER NO CIRCUMSTANCE USE System.exit(0) !!!
          // It shuts down the JVM !!!!
          // System.exit(0);
          mainFrame.setVisible(false);
          mainFrame.dispose();
        }
      });

    mainPanel = new JPanel();
		mainPanel.setBorder(BorderFactory.createLineBorder(Color.black));
    mainPanel.setLayout(new GridLayout(4, 1));

    // Add the widgets.
    addWidgets();

    // Add the return button
		returnButton = new JButton("Back to the real MuPAD", new ImageIcon("cube.gif"));
		returnButton.setToolTipText("Click this button to return to MuPAD.");
    returnButton.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          mainFrame.setVisible(false);
          mainFrame.dispose();
        }
      });

    // Add the panels to the frame.
    mainFrame.getContentPane().add(mainPanel, BorderLayout.CENTER);
    mainFrame.getContentPane().add(returnButton, BorderLayout.SOUTH);

    // Show the frame.
    mainFrame.pack();
    mainFrame.setVisible(true);
    mainFrame.toFront();
    center(mainFrame);
  }

  // Constructor
  public SimpleCalculator(String text) {
    this();
    queryField.setText(text);
  }

  // Create and add the widgets for converter.
  private void addWidgets() {
    // Create widgets.
    queryField    = new JTextField(40);
    questionLabel = new JLabel("Please enter a query:", SwingConstants.LEFT);
    calcButton    = new JButton("Calculate...");
		calcButton.setToolTipText("Click this button to send a query to MuPAD.");
    answerLabel   = new JLabel("MuPAD returned:", SwingConstants.LEFT);

    // Listen to events from Convert button.
    calcButton.addActionListener(this);

    // Add widgets to container.
    mainPanel.add(questionLabel);
    mainPanel.add(queryField);
		mainPanel.add(answerLabel);
    mainPanel.add(calcButton);

    questionLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    answerLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
  }

  // Implementation of ActionListener interface.
  public void actionPerformed(ActionEvent event) {
    String text = calcMuPAD(queryField.getText());
    answerLabel.setText("MuPAD returned: " + text);
    System.out.println("MuPAD calculated for " + queryField.getText() +": " + text);
  }

  // main method
  public static void main(String[] args) {
    // Set the look and feel.
    try {
      UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    } catch (Exception e) {
    }

    if (args.length == 0) {
      SimpleCalculator calculator = new SimpleCalculator();
    }
    else {
      // Take the first argument and built a new Calculator.
      SimpleCalculator calculator = new SimpleCalculator(args[0]);
    }
  }
}
