import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;


// Extend SecurityException so that we can differentiate between CheckExit() and other
// security violations (and make the code more readable) and
// return the exit status to the shell so it can print it out.
class ExitException extends SecurityException {
		private int value = 0;
		public ExitException() {}
		public ExitException(int value) {
				super();
				this.value = value;
		}
		public int value() { return value; }
}

// Create a security manager so that we can prevent users from terminating the JVM.
public class MuPADSecurityManager extends SecurityManager {
  public void checkAccept(String host, int port) {}
  public void checkAccess(Thread g) { }
  public void checkAccess(ThreadGroup g) { }
  public void checkAwtEventQueueAccess() { }

  public void checkConnect(String host, int port) { }
  public void checkConnect(String host, int port, Object context) { }
  public void checkCreateClassLoader() { }

  public void checkDelete(String file) { }

	public void checkExit(int status) {
		  System.runFinalization();
			//System.out.println("ShellSecurityManager: object called System.exit(" + status + ")");
			// signal that someone is trying to terminate the JVM.
			throw new ExitException(status);
	}
	public void checkExec(String cmd) { }

	public void checkLink(String lib) { }
  public void checkListen(int port) {}

  public void checkMemberAccess(Class<?> clazz, int which) {}
  public void checkMulticast(InetAddress maddr) { }

  public void checkPackageAccess(String pkg) { }
  public void checkPackageDefinition(String pkg) { }
  public void checkPermission(Permission perm) {}
  public void checkPermission(Permission perm, Object context) {}
  public void checkPrintJobAccess() { }
  public void checkPropertiesAccess() { }
  public void checkPropertyAccess(String key) { }
  public void checkPropertyAccess(String key, String def) { }

	public void checkRead(FileDescriptor fd) { }
	public void checkRead(String file) { }
	public void checkRead(String file, Object context) { }

  public void checkSecurityAccess(String provider) { }
  public void checkSetFactory() { }
  public void checkSystemClipboardAccess() { }

  public boolean checkTopLevelWindow(Object window) { return true; }

  public void checkWrite(FileDescriptor fd) { }
	public void checkWrite(String file) { }

	public static void setSecurityManager() {
		System.setSecurityManager(new MuPADSecurityManager());
	}
}
