import java.util.Enumeration;
import java.util.Hashtable;


/**
 * This class handles the storage of all MuPAD-unknown data-formats.
 * @author Jrn Maas
 */
public class HandleObjects {

  private Hashtable hashTable = new Hashtable();

  public void put(String key, Object object) {
    hashTable.put(key, object);
  }

  public Object getObject(String key) {
    if (hashTable.containsKey(key)) {
      return hashTable.get(key);
    } else {
      return null;
    }
  }

  public void remove(String key) {
    hashTable.remove(key);
  }

  public void clear() {
    hashTable.clear();
  }

  public int size() {
    return hashTable.size();
  }

  public String getSignature(String key) {
    if (hashTable.containsKey(key)) {
      Object obj = hashTable.get(key);
      String oldSign = obj.getClass().getName();
      if (oldSign.charAt(0) == '[') {
        return oldSign;
      }
      else {
        return "L" + oldSign + ";";
      }

    } else {
      return null;
    }
  }

  public String getClassname(String key) {
    if (hashTable.containsKey(key)) {
      Object obj = hashTable.get(key);
      return obj.getClass().getName().replace('.','/');
    } else {
      return null;
    }
  }

  /**
   * returns a literal list containing all the objects stored.
   * @param showInJava if set to true it will show the objects in a Swing PopUp Box.
   * @return A list containing the literal description of the objects.
   */
  public String[] getList(boolean showInJava) {
    int counter = 0;
    String javaList = "";
    String[] list;

    if (hashTable.isEmpty()) {
      if (showInJava) {
        javax.swing.JOptionPane.showMessageDialog(null, "No entries available", "Entries...", javax.swing.JOptionPane.INFORMATION_MESSAGE);
      }
      return null;
    }

    list = new String[hashTable.size()];
    Enumeration e = hashTable.keys();

    while (e.hasMoreElements()) {
      String alias = (String)e.nextElement();
      list[counter] = "Entry ["+ counter + "] (" + alias + ") = " + hashTable.get(alias).getClass().getName() + '\n';
      javaList += "Entry ["+ counter + "] (" + alias + ") = " + hashTable.get(alias).getClass().getName() + '\n';
      counter++;
    }

    if (showInJava) {
      javax.swing.JOptionPane.showMessageDialog(null, javaList, "Stored java objects", javax.swing.JOptionPane.INFORMATION_MESSAGE);
    }
    return list;
  }

}