import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.TextField;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/**
 * AppletStarter - implements AppletContext and AppletStub to allow any
 * applet to easily run as an application.  The only thing it can't do is
 * access URL's.  Applet parameters are entered on the command line with
 * name as one word and value as the next.
 */

public class AppletStarter extends Frame
    implements AppletStub, AppletContext, URLStreamHandlerFactory {

    private TextField status;
    private Hashtable params = new Hashtable();
    private Vector applets = new Vector();

    private int initial_width;
    private int initial_height;

    private static Applet applet = null;

    private static boolean handlerSet = false;

	/**
	 * Entry point into the standalone program.
	 *
	 * @param args  the command line arguments
	 */
    public static void main ( String args[] ) {
        new AppletStarter( args );
    }

	/**
	 * Constructor for the main class, given an existing applet object.
	 *
	 * @param applet            the applet embedded in this AppletContext
	 * @param args              the command line arguments.  Contains possibly
	 *                          height and width, and any applet parameters
	 */
    public AppletStarter( Applet applet, String args[] ) {

        this( applet, args, 640, 480 );
    }

	/**
	 * Constructor for the main class, given an existing applet object and a default
	 * frame (window) width and height.
	 *
	 * @param applet            the applet embedded in this AppletContext
	 * @param args              the command line arguments.  Contains possibly
   *                          height and width, and any applet parameters
   * @param default_width     the default width of the window
   * @param default_height    the default width of the window
	 */
    public AppletStarter( Applet applet, String args[], int default_width, int default_height ) {

        super ( applet.getClass().getName() );
        init( applet, args, default_width, default_height, 0 );
    }

	/**
	 * Constructor for the main class, from the command line arguments.
	 *
	 * @param args  the command line arguments.  Contains the name of the applet
	 *              class, possibly height and width, and any applet parameters.
	 */
    public AppletStarter( String args[] ) {

        super ( args[0] );

        try {
            this.applet = (Applet)Class.forName( args[0] ).newInstance();

            init( applet, args, 640, 480, 1 );
        }
        catch ( Exception e ) {
            e.printStackTrace();
            this.dispose();
            try {
              this.finalize();
            }
            catch (Throwable e2) {}
        }
    }

	/*
	 * PRIVATE initialization function.
	 *
	 * @param applet2           the applet embedded in this AppletContext
   * @param args              the command line arguments.  Contains possibly
   *                          height and width, and any applet parameters
	 * @param default_width     the default width of the window
	 * @param default_height    the default width of the window
	 * @param startidx          index in the args array at which to start parsing
	 */
    private void init( Applet applet2, String args[], int default_width, int default_height,
                       int startidx ) {

        if (this.applet != null) {
          this.applet.destroy();
        }

        this.applet = applet2;
        System.out.println("HandlerSet = " + handlerSet);

        if (!handlerSet) {
          URL.setURLStreamHandlerFactory( this );
          this.handlerSet = true;
        }

        applets.addElement( applet );
        applet.setStub(this);

        initial_width = default_width;
        initial_height = default_height;

        parseArgs( args, startidx );

        status = new TextField();
        status.setEditable( false );

        add( "Center", applet );
        add( "South", status );

        appletResize( initial_width, initial_height );

        show();
        applet.init();
        applet.start();
        status.setText("ONLY CLOSE THE PROGRAM USING THE WINDOW CLOSER (X in the upper right corner)!");
    }

    public void destroy() {
      this.applet.stop();
      this.applet.destroy();
      this.applet = null;
    }

    public void killFrame() {
      this.setVisible(false);
      destroy();
      this.dispose();
    }

	/**
	 * Parse the command line arguments.  Get the initial width and height of
	 * the window if specified (-width [value] -height [value]), and the
	 * applet parameters (name value pairs).
	 *
	 * @param args              the command line arguments.  Contains possibly
	 *                          height and width, and any applet parameters
	 * @param startidx          index in the args array at which to start parsing
	 */
    public void parseArgs( String args[], int startidx ) {
        for ( int idx = startidx; idx < ( args.length - startidx ); idx+=2 ) {
            try {
                if ( args[idx].equals( "-width" ) ) {
                    initial_width = Integer.parseInt( args[idx+1] );
                }
                else if ( args[idx].equals( "-height" ) ) {
                    initial_height = Integer.parseInt( args[idx+1] );
                }
                else {
                    params.put( args[idx], args[idx+1] );
                }
            }
            catch ( NumberFormatException nfe ) {
                System.err.println("Warning: command line argument "+args[idx]+
                                   " is not a valid number." );
            }
        }
    }

	/**
	 * Event handler to catch the Frame (window) close action,
	 * and exit the program.
	 *
	 * @param evt   The event that occurred
	 * @return      false if the event was not handled by this object.
	 */
    public boolean handleEvent( Event evt ) {

        if ( evt.id == Event.WINDOW_DESTROY ) {
          System.out.println("Shutting down the AppletStarter...");
          setVisible(false);
          this.applet.destroy();
          dispose();
          try {
            finalize();
          }
          catch (Throwable e) {}
        }

        return super.handleEvent(evt);
    }

    /************ AppletStub methods *************/

    /**
     * Returns true if the applet is active.
     *
     * @return  always true
     */
    public boolean isActive() { return true; }

    /**
     * Gets the document URL.
     *
	 * @return      a "file:" URL for the current directory
     */
    public URL getDocumentBase() {
        URL url = null;
        try {
            File dummy = new File(""); //"dummy.html" );

            String path = dummy.getAbsolutePath();
            //System.out.println("getDocBase : absPath 1=" + path);
            path = path.replace('\\','/');
            //System.out.println("getDocBase : absPath 2=" + path);
            if (!(path.charAt(path.length()-1) == '/'))
              path = path + "/";
/*
            if ( ! File.separator.equals( "/" ) ) {
                StringBuffer buffer = new StringBuffer();
                if ( path.charAt(0) != File.separator.charAt(0) ) {
                    buffer.append( "/" );
                }
                StringTokenizer st = new StringTokenizer( path, File.separator );
                while ( st.hasMoreTokens() ) {
                    buffer.append( st.nextToken() + "/" );
                }
                if ( File.separator.equals( "\\" ) &&
                     ( buffer.charAt(2) == ':' ) ) {
                    buffer.setCharAt( 2, '|' );
                }
                else {
                }
                path = buffer.toString();
                path = path.substring( 0, path.length()-1 );
            }
*/
            //url = new URL( "http", "localhost/" , 3760, "");
            url = new URL( "file", "localhost/" , -1, path);
            //System.out.println("getDocBase : url =" + url.toExternalForm());

        }
        catch ( MalformedURLException mue ) {
            mue.printStackTrace();
        }
        catch (Throwable e) {
        }
        return url;
    }

    /**
     * Gets the codebase URL.
     *
	 * @return      in this case, the same value as getDocumentBase()
     */
    public final URL getCodeBase() { return getDocumentBase(); }

    /**
     * Gets a parameter of the applet.
     *
	 * @param name  the name of the parameter
	 * @return      the value, or null if not defined
	 */
    public final String getParameter( String name ) {
        return (String)params.get( name );
    }

	/**
	 * Gets a handler to the applet's context.
	 *
	 * @return  this object
	 */
    public final AppletContext getAppletContext() { return this; }

	/**
	 * Called when the applet wants to be resized.  This causes the
	 * Frame (window) to be resized to accomodate the new Applet size.
	 *
	 * @param width     the new width of the applet
	 * @param height    the new height of the applet
	 */
    public void appletResize( int width, int height ) {

        Insets insets = insets();

        resize( ( width + insets.left + insets.right ),
                ( height + status.preferredSize().height +
                  insets.top + insets.bottom ) );
    }

/************ AppletContext methods *************/

	/**
     * Gets an audio clip.  (There doesn't seem to be a "Toolkit" for
     * audio clips in my JDK, so this always returns null.  You could
     * implement this differently, returning a dummy AudioClip object
     * for which the class could be defined at the bottom of this file.)
	 *
	 * @param url   URL of the AudioClip to load
	 * @return      the AudioClip object if it exists (in our case,
	 *              this is always null
	 */
    public final AudioClip getAudioClip( URL url ) { return null; }

	/**
     * Gets an image. This usually involves downloading it
     * over the net. However, the environment may decide to
     * cache images. This method takes an array of URLs,
     * each of which will be tried until the image is found.
	 *
	 * @param url   URL of the Image to load
	 * @return      the Image object
	 */
    public final Image getImage( URL url ) {
        return Toolkit.getDefaultToolkit().getImage( filenameFromURL( url ) );
    }

	/*
     * PRIVATE utility function.  Ignores the protocol, and returns a
     * filename for a file on the local filesystem (which may or may
     * not exist, of course).
	 *
	 * @param url   URL to be converted to a filename on the local
	 *              filesystem.
	 * @return      the filename
	 */
    private String filenameFromURL( URL url ) {
        String filename = url.getFile();
        if ( filename.charAt(1) == '|' ) {
            StringBuffer buf = new StringBuffer( filename );
            buf.setCharAt( 1, ':' );
            filename = buf.toString();
        }
        else if ( filename.charAt(2) == '|' ) {
            StringBuffer buf = new StringBuffer( filename );
            buf.setCharAt( 2, ':' );
            filename = buf.toString();
        }
        return filename;
    }

	/**
     * Gets an applet by name.
     *
	 * @param name  the name of the applet
     * @return      null if the applet does not exist, and it never
     *              does since we never name the applet.
	 */
    public final Applet getApplet( String name ) { return null; }

	/**
     * Enumerates the applets in this context. Only applets
     * that are accessible will be returned. This list always
     * includes the applet itself.
	 *
	 * @return  the Enumeration -- contains ONLY the applet created with
	 *          this DummyAppletContext
	 */
    public final Enumeration getApplets() { return applets.elements(); }

	/**
     * Shows a new document. This may be ignored by
     * the applet context (and in our case, it is, but we'll show the
     * user, in the status area, that the document was requested and
     * WOULD be loaded if in a browser).
	 *
	 * @param url   URL to load
	 */
    public void showDocument( URL url ) {
        status.setText( "AppletContext request to show URL " +
                        url.toString() );
    }

	/**
     * Show a new document in a target window or frame. This may be ignored by
     * the applet context.  (Again, it is ignored, but we'll show the
     * request information to the user in the status area.)
     *
     * This method accepts the target strings:
     *   _self		show in current frame
     *   _parent	show in parent frame
     *   _top		show in top-most frame
     *   _blank		show in new unnamed top-level window
     *   <other>	show in new top-level window named <other>
	 *
	 * @param url       URL to load
	 * @param target    the target string
	 */
    public void showDocument( URL url, String target ) {
        status.setText( "AppletContext request to show URL " +
                        url.toString() +
                        " in target: " + target );
    }

	/**
     * Show a status string in the status area (the Text object at the bottom
     * of the window.
	 *
	 * @param text  the text to display
	 */
    public void showStatus( String text ) { status.setText( text ); }

/************ URLStreamHandlerFactory methods *************/

	/**
     * Creates a new URLStreamHandler instance with the specified protocol.
     *
     * @param protocol  the protocol to use (ftp, http, nntp, etc.).
     *                  THIS PROTOCOL IS IGNORED BY THIS APPLET CONTEXT
     */
    public URLStreamHandler createURLStreamHandler( String protocol ) {
        return new DummyURLStreamHandler();
    }

    public void setStream(String key, InputStream stream) { }
    public InputStream getStream(String key) { return null; }
    public Iterator getStreamKeys() { return null; }

}

/*
 * A URL stream handler for all protocols, used to return our
 * dummy implementation of URLConnection to open up a local
 * file when called upon.
 */

class DummyURLStreamHandler extends URLStreamHandler {


    protected final URLConnection openConnection( URL u ) throws IOException {
        return new DummyURLConnection( u );
    }

}

/*
 * Our dummy implementation of URLConnection used to open up a local
 * file when called upon with a given URL of ANY protocol type.  This
 * allows the applet to easily use the "getInputStream()" function.
 */

class DummyURLConnection extends URLConnection {

    boolean connected = false;
    InputStream instream;

    /*
     * Constructor for the DummyURLConnection
     */

    protected DummyURLConnection( URL url ) {
        super( url );
    }

    /*
     * open the local file
     */

    public void connect() throws IOException {
        if ( ! connected ) {
            String filename = url.getFile();
            if ( filename.charAt(1) == '|' ) {
                StringBuffer buf = new StringBuffer( filename );
                buf.setCharAt( 1, ':' );
                filename = buf.toString();
            }
            else if ( filename.charAt(2) == '|' ) {
                StringBuffer buf = new StringBuffer( filename );
                buf.setCharAt( 2, ':' );
                filename = buf.toString();
            }
            instream = new FileInputStream( filename );
        }
    }

    /*
     * return the open stream to the local file (open if necessary).
     */

    public InputStream getInputStream() throws IOException {
        if ( ! connected ) {
            connect();
        }
        if ( instream == null ) {
            throw new IOException();
        }
        return instream;
    }
}