/***************************************************************/
/* FILE   :  Module Management code of a dynamic MuPAD module  */
/* CREATED:  on 19.Feb.07, by module generator mmg R-4.0.2-0   */
/* SOURCE :  usejava.cpp                     - is #include(d)  */
/* SYSTEMS:  This file can be used with the following systems  */
/*           and also on newer releases of these systems.      */
/*                                                             */
/*           Amiga      : NetBSD 1.2              (aminetbsd)  */
/*           DECalpha   : OSF1 V3.2                   (alpha)  */
/*           HP         : HP-UX R-9.0                    (hp)  */
/*           IBM/AT     : FreeBSD 2.0               (freebsd)  */
/*           IBM/AT     : Linux 1.2.9, ELF             (i386)  */
/*           IBM/AT     : NetBSD 1.2                 (netbsd)  */
/*           IBM/AT     : SunOS 5.x (Solaris)         (i86pc)  */
/*           IBM/AT     : Windows 95/98/NT          (windows)  */
/*           IBM/RS6000 : AIX 3.1, 4.x            (ibmrs6000)  */
/*           PowerMac   : Apple System 7.5              (mac)  */
/*           SGI/Indigo : IRIX 5.1.1, 6.x              (sgi5)  */
/*           Sun/Sparc  : SunOS 4.0.3                  (sun4)  */
/*           Sun/Sparc  : SunOS 5.x (Solaris)       (solaris)  */
/***************************************************************/
#define MuPAD40                            // the MuPAD Version
#define ISMODULE                           // for internal usage 
#define MMG(vvv)                           // hide these options 
#define MPROC(vvv)                         // hide these options 
#define MEXPR(vvv)                         // hide these options 
                                                                 
// Some essential definements needed for a MuPAD kernel          
//                                                               
#define LONG_IS_32BIT     
#define PARI_LITTLE_ENDIAN
#define MMMDLEAN          
#define MMMDGARBAGE       
#define MDX               
                                                                 
// User-defined C-code prefix                                    
//                                                               
                                                                 
// Define some kind of module names (for internal usage)         
//                                                               
#define MD_MODULE            usejava                                  
#define MD_MODSTR            MD_STRING(usejava::)                     
#define MD_MF_NAME(MD_name)  MFeval_usejava_ ## MD_name               
                                                                 
// Module name (for generell usage)                              
//                                                               
#define MCmodule             MD_STRING(usejava)                       
                                                                 
// Use the dynamic linker to access MuPAD kernel objects ?       
//                                                               
// #define MDMD_USE_DYNLINK                                       
                                                                 
// Essential types and constants of the module management        
//                                                               
#include "MDM_base.h"                                          
                                                                 
// Compare release number of the module generator with that      
// defined in the MuPAD kernel header files  and produce an      
// error if they differ too much.                                
//                                                               
#if MDM_BAD_RELEASE(4020UL)                                  
#   error "!!! BAD RELEASE OF MuPAD KERNEL-INCLUDES !!!"       
#endif                                                           
                                                                 
// Define methods to access MuPAD kernel objects. They are       
// are not used if MDMD_USE_DYNLINK is defined.                  
//                                                               
#define MDM_K_FUNC(obj) (*MDM_usejava_jump_kernel)(obj,__FILE__,__LINE__)
#define MDM_K_TABL(obj)   MDM_usejava_jump_kernel_fast[obj]           
                                                                 
// Select method for MuPAD kernel access.                        
//                                                               
#define MDM_K  MDM_K_TABL                                                
                                                                 
// Local variables to store the MuPAD kernel entry points.       
//                                                               
MDM_jump_fun_t  MDM_usejava_jump_kernel;                            
MDM_jump_t     *MDM_usejava_jump_kernel_fast;                       
                                                                 
// Essential kernel types and definitions (API).                 
//                                                               
#include "MKT_mapi.h"                                          
                                                                 
// Dummy main function needed on SOLARIS (g++ 2.95.2)            
#ifdef SOLARIS                                                   
    int main(int argc, char*argv[]){}                            
#endif                                                           
                                                                 
// The module information string, including the user info.       
//                                                               
static CONST char *MF_info =                                     
"Module: 'usejava' created on 19.Feb.07 by mmg V-4.0.2-0\n";        
                                                                 
// The module documentation interface function.                  
//                                                               
MD_FUNC_HEADER( doc, MCnop )                                     
{                                                                
    char    cmd[256];                                            
                                                                 
    MFnargsCheckRange( 0, 1 );                                   
    if( MVnargs == 1 ) {                                         
        MFargCheck( 1, MCchar );                                 
        sprintf( cmd, "module::help(\"usejava\",\"%s\")",  
                 MFstring(MFarg(1)) );                           
    } else {                                                     
        sprintf( cmd, "module::help(\"usejava\")" );            
    }                                                            
    MFfree( MFeval(MF(cmd)) );                                   
    MFreturn( MFcopy(MVnull) );                                  
} MD_FUNC_FOOTER()                                               
                                                                 
// Include the user's module source code.                        
/////////////////////////////////////////////////////////////////
#include "usejava.cpp"                                                  
/////////////////////////////////////////////////////////////////
                                                                 
// The module function table contains names and addresses.       
//                                                               
static CONST MDM_fun_t MDM_func_list[] = {                       
  { "callHO_clearList", (MDM_jump_t) MD_MF_NAME(callHO_clearList), MDMC_FF_ZERO },
  { "callHO_getClassname", (MDM_jump_t) MD_MF_NAME(callHO_getClassname), MDMC_FF_ZERO },
  { "callHO_getList", (MDM_jump_t) MD_MF_NAME(callHO_getList), MDMC_FF_ZERO },
  { "callHO_getSignature", (MDM_jump_t) MD_MF_NAME(callHO_getSignature), MDMC_FF_ZERO },
  { "callHO_removeObject", (MDM_jump_t) MD_MF_NAME(callHO_removeObject), MDMC_FF_ZERO },
  { "console"   , (MDM_jump_t) MD_MF_NAME(console     ), MDMC_FF_ZERO },
  { "debug"     , (MDM_jump_t) MD_MF_NAME(debug       ), MDMC_FF_ZERO },
  { "doc"       , (MDM_jump_t) MD_MF_NAME(doc         ), MDMC_FF_ZERO },
  { "finalize"  , (MDM_jump_t) MD_MF_NAME(finalize    ), MDMC_FF_ZERO },
  { "garbageCollect", (MDM_jump_t) MD_MF_NAME(garbageCollect), MDMC_FF_ZERO },
  { "getStatus" , (MDM_jump_t) MD_MF_NAME(getStatus   ), MDMC_FF_ZERO },
  { "invoke"    , (MDM_jump_t) MD_MF_NAME(invoke      ), MDMC_FF_ZERO },
  { "list"      , (MDM_jump_t) MD_MF_NAME(list        ), MDMC_FF_ZERO },
  { "match"     , (MDM_jump_t) MD_MF_NAME(match       ), MDMC_FF_ZERO },
  { "returnFourtyTwo", (MDM_jump_t) MD_MF_NAME(returnFourtyTwo), MDMC_FF_ZERO },
  { "setShowErrors", (MDM_jump_t) MD_MF_NAME(setShowErrors), MDMC_FF_ZERO },
  { "start"     , (MDM_jump_t) MD_MF_NAME(start       ), MDMC_FF_ZERO },
  { "stop"      , (MDM_jump_t) MD_MF_NAME(stop        ), MDMC_FF_ZERO },
  { NULL, NULL }                                                 
};                                                               
                                                                 
// The following function must use the 'func' kernel entry!      
//                                                               
#undef  MDM_K                                                    
#define MDM_K MDM_K_FUNC                                         
                                                                 
#ifdef MACINTOSH                                                 
#  pragma export on                                              
#endif                                                           
                                                                 
#if (defined MSDOS || defined WIN32) && !defined __GNUC__        
  __declspec(dllexport) long __cdecl                             
#else                                                            
  extern "C" long                                              
#endif                                                           
 MDM_V402()                                                   
 {                                                               
     return( 0 );                                               
 }                                                               
#ifdef MACINTOSH                                                 
#  pragma export off                                             
#endif                                                           
                                                                 
/***************************************************************/
/* NAME : MDM_modul_init                                       */
/* ARGS : release   = IN : release number of the MuPAD kernel  */
/*        lsc       = OUT: module lsc                          */
/*        modinfo   = OUT: module information string           */
/*        flags     = OUT: module attributes                   */
/*        funcs     = OUT: number of module functions          */
/*        func_list = OUT: table  of module functions          */
/*        kernel    = IN : kernel entry point ('func')         */
/*                                                             */
/* This function is called when this dynamic module is loaded  */
/* by a MuPAD kernel. It is used to exchange essential infor-  */
/* mation for the module management.                           */
/***************************************************************/
#ifdef MACINTOSH                                                 
#  pragma export on                                              
#endif                                                           
                                                                 
#if (defined MSDOS || defined WIN32) && !defined __GNUC__        
  __declspec(dllexport) long __cdecl                             
#else                                                            
  extern "C" long                                              
#endif                                                           
  MDM_modul_init (                                               
            unsigned long   release,                             
            unsigned long  *lsc,                                 
            char          **modinfo,                             
            unsigned long  *flags,                               
            long           *funcs,                               
            MDM_fun_t     **func_list,                           
            MDM_jump_fun_t  kernel                               
  ) {                                                            
    if( MDM_BAD_RELEASE(release) ) MFprintf(                     
        "Warning: Module 'usejava' was created for R-4.0.2-0\n" 
        "         You may need to recompile it.\n"            
    );                                                           
                                                                 
    MDM_usejava_jump_kernel      = kernel;                            
    MDM_usejava_jump_kernel_fast = (MDM_jump_t*) MDMV_object_tab;     
    *modinfo   = (char*)       MF_info;                          
    *func_list = (MDM_fun_t *) MDM_func_list;                    
    *funcs     = 18L;                                            
    *flags     = 0L;                                            
    *lsc       = 0L;                                            
                                                                 
    return( MDMC_OK );                                           
}                                                                
#ifdef MACINTOSH                                                 
#  pragma export off                                             
#endif                                                           
                                                                 
// Pseudo modules need a global handle for this function.        
//                                                               
MDM_pinit_t  MDM_pusejava_init = MDM_modul_init;                      
                                                                 
