// **************************************************************************
// Java - Zugriff auf Java-Klassen aus MuPAD heraus
//
// DATUM: Mai 2003
// MuPAD: Version 3.0.0 / 2.5.2
// AUTOR: Jrn Maas, Andreas Sorgatz 
// **************************************************************************

java := newDomain(hold(java)):
//java::info := "java: Ein Package zum Zugriff auf Java-Klassen in MuPAD.":
// evtl. per SLOT die Methoden umdefinieren knnen, also wenn
// java::a::b::c(...) eingegeben wird, macht MuPAD daraus:
// a.b.c(...) und ruft das dann in Java auf... ???

java::info := "a Java VM for MuPAD":
java::interface := {}:

/****************************************************************************/
/****************************************************************************/

proc()
local modname, offset, old_READPATH;
  save PRETTYPRINT;
begin
  modname:= "usejava";
  old_READPATH := READPATH;
  /* add modules version dir to READPATH */
  READPATH := stringlib::remove(FILEPATH, pathname("lib", "LIBFILES")).
              pathname("modules", sysname(Arch),
                       "".version()[1].".".version()[2].".".version()[3]),
              READPATH;
  if module::which(modname) = FAIL then
     PRETTYPRINT:= FALSE;
     READPATH := old_READPATH;
     print(Unquoted,
           "Das Java-Package untersttzt Ihre Hardware und/oder Ihre\n"
          ."MuPAD-Version derzeit leider nicht. Wenden Sie sich\n"
          ."mit der Bitte um Untersttzung ggf. an den Autor."
     ):
     return();
  end_if;

java::interface := 
{ 
 hold(list), hold(match), hold(start), hold(getPath), hold(setWorkingDirectory), 
 hold(getStatus), hold(getWorkingDirectory), hold(console), hold(matrixEditor),
 hold(getMatrix), hold(showJavaInfo), hold(runApplet), hold(closeAppletFrame)
}:

java::module:= module(modname):
/****************************************************************************/
/****************************************************************************/
java::javaRootPath := stringlib::remove(FILEPATH, pathname("lib", "LIBFILES"));

java::classpath := stringlib::remove(FILEPATH, pathname("lib", "LIBFILES"))."classes";
java::libpath := stringlib::remove(FILEPATH, pathname("lib", "LIBFILES")).pathname("javart", "jre", "lib");
//java::libpath  := stringlib::remove(module::which(modname), pathname("").modname);

if sysname() = "MSDOS" then
  java::separator := ";";
  java::libpath := java::libpath . ";" . java::classpath . ";";
  java::classpath := java::classpath . ";"; 
  //. stringlib::remove(FILEPATH, pathname("lib", "LIBFILES")).pathname("javart", "jre", "lib") . "rt.jar;";
  java::dllpath  := stringlib::remove(FILEPATH, pathname("lib", "LIBFILES")).pathname("javart", "jre", "bin" , "server");
elif sysname() = "UNIX" then
  if sysname(Arch) = "linux" then
    java::separator := ":";
    //java::libpath := java::libpath . "i386/:" . java::classpath . ":";
    java::classpath:= java::classpath . ":";
    java::libpath := java::libpath . ":" . java::classpath;
    // . stringlib::remove(FILEPATH, pathname("lib", "LIBFILES")).pathname("javart", "jre", "lib") . "rt.jar:";
    java::dllpath  := stringlib::remove(FILEPATH, pathname("lib", "LIBFILES")).pathname("javart", "jre", "lib" , "i386" , "server");
  elif sysname(Arch) = "Darwin" then
    // On MAC OS there is always only one JVM !!!
    java::separator := ":";
    java::classpath := java::classpath . ":";
    java::libpath := "/System/Library/Frameworks/JavaVM.framework/Libraries:";
    java::dllpath  := "/System/Library/Frameworks/JavaVM.framework/Libraries/";
  end_if;
// elif sysname() = "..." then
end_if;

  java::Name := java::key;
  java::make_slot := proc(Domain, idx)
    local jd; //, offset; //, arguments, tmp, tmp2, tmp3
    begin

      //if version()[1] = 2 then
      //  offset:=0;
      //else
      //  offset:=1;
      //end_if;
      
      //tmp := level(context(text2expr(idx)),MAXLEVEL);
      //tmp2:= type(tmp);
       
      //if tmp2 = DOM_STRING then
      //   tmp3:= substring(tmp,offset,1);
      //   if tmp3 = "@" then
      // 	   idx := "REF_".substring(tmp,offset+1,length(tmp)-1-offset);
      //   end_if;
      //end_if;

      jd := newDomain(hold(slot)(Domain, idx)):
      jd::Name := jd::key;
      jd::new := () -> java::invoke(dom, args()): 
      jd::interface := java::createInterface(jd):
      jd::make_slot := java::make_slot:
      jd
    end:
/*  
  sysassign(java::isObject, FALSE);
  sysassign(java::objName, "");
  java::Name := java::key;
  java::make_slot := proc(Domain, idx)
    local bla, arguments, tmp, tmp2, tmp3, offset;
    begin
      if version()[1] = 2 then
        offset:=0;
      else
        offset:=1;
      end_if;

      tmp := level(context(text2expr(idx)),MAXLEVEL);
      tmp2:= type(tmp);       
      if tmp2 = DOM_STRING then
        tmp3:= substring(tmp,offset,10);
        if tmp3 = "@MuPAD_JNI" then
          idx := java::module::callHO_getClassname(tmp);
          sysassign(java::isObject,TRUE);
          sysassign(java::objName, tmp);
          //idx := "REF_".substring(tmp,offset+1,length(tmp)-1-offset);
        end_if;
      end_if;
      bla := newDomain(hold(slot)(Domain, idx));
      bla::Name := bla::key;
      if java::isObject then
        bla::new := fp::unapply(hold(java::invoke)(hold(dom), hold(args()), hold(hold(UseObject))=java::objName),x):
      else
        bla::new := () -> java::invoke(dom, args()):
      end_if;
      // bla::new := () -> java::invoke(dom, args()):
      // java::invoke(dom, arguments):
      bla::make_slot := java::make_slot;
      //if java::isObject then
      //	   bla:= subs(bla,`#JAVA_BLA_MUFF`=hold(hold(UseObject)=java::objName));
      //else
      //	   bla:= subs(bla,`#JAVA_BLA_MUFF`=null());
      //end_if;
      bla;
    end:
*/

/****************************************************************************/
/****************************************************************************/
  java::invoke              := loadproc( java::invoke,              pathname("JAVA"), "invoke"):
  java::list                := loadproc( java::list,                pathname("JAVA"), "list"):
  java::match               := loadproc( java::match,               pathname("JAVA"), "match"):
  java::start               := loadproc( java::start,               pathname("JAVA"), "start"):
  java::stop                := loadproc( java::stop,                pathname("JAVA"), "stop"):
  java::callHO_getList     := loadproc( java::callHO_getList,     pathname("JAVA"), "callHO_getList"):
  java::callHO_removeObject := loadproc( java::callHO_removeObject, pathname("JAVA"), "callHO_removeObject"):
  java::callHO_clearList    := loadproc( java::callHO_clearList,    pathname("JAVA"), "callHO_clearList"):
  java::callHO_getSignature := loadproc( java::callHO_getSignature, pathname("JAVA"), "callHO_getSignature"):
  java::callHO_getClassname := loadproc( java::callHO_getClassname, pathname("JAVA"), "callHO_getClassname"):
  java::getWorkingDirectory := loadproc( java::getWorkingDirectory, pathname("JAVA"), "getWorkingDirectory"):
  java::setWorkingDirectory := loadproc( java::setWorkingDirectory, pathname("JAVA"), "setWorkingDirectory"):
  java::matrixEditor        := loadproc( java::matrixEditor,        pathname("JAVA"), "matrixEditor"):
  java::getMatrix           := loadproc( java::getMatrix,           pathname("JAVA"), "getMatrix"):
  java::getPath             := loadproc( java::getPath,             pathname("JAVA"), "getPath"):
  java::checkNumber         := loadproc( java::checkNumber,         pathname("JAVA"), "checkNumber"):
  java::checkForMatches     := loadproc( java::checkForMatches,     pathname("JAVA"), "checkForMatches"):
  java::getStatus           := loadproc( java::getStatus,           pathname("JAVA"), "getStatus"):
  java::debug               := loadproc( java::debug,               pathname("JAVA"), "debug"):
  java::setJavaKey          := loadproc( java::setJavaKey,          pathname("JAVA"), "setJavaKey"):
  java::showJavaInfo        := loadproc( java::showJavaInfo,        pathname("JAVA"), "showJavaInfo"):
  java::showMatrix          := loadproc( java::showMatrix,          pathname("JAVA"), "showMatrix"):
  java::console             := loadproc( java::console,             pathname("JAVA"), "console"):
  java::closeAppletFrame    := loadproc( java::closeAppletFrame,    pathname("JAVA"), "closeAppletFrame"):
  java::runApplet           := loadproc( java::runApplet,           pathname("JAVA"), "runApplet"):
  java::garbageCollect      := loadproc( java::garbageCollect,      pathname("JAVA"), "garbageCollect"):
  java::createInterface     := loadproc( java::createInterface,     pathname("JAVA"), "createInterface"):
  java::finalize            := loadproc( java::finalize,            pathname("JAVA"), "finalize"):
/****************************************************************************/
/****************************************************************************/
end_proc():

//stdlib::LoadlibState["java"] := TRUE:
null():

