// **************************************************************************
// FUNCTION: start
// DATE    : 19 Juni 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// optional Parameter 1 <Expr>   : ClassPath = <String>
// optional Parameter 2 <Expr>   : LibraryPath = <String>
// optional Parameter 3 <Expr>   : DLLPath = <String>
// optional Parameter 4 <Expr>   : UseSecurityManager = <Boolean>
// optional Parameter 5 <Expr>   : UseLogFile = <Boolean>
// optional Parameter 6 <Expr>   : UseOptionList = <List>
// **************************************************************************
// Return : Either TRUE if it worked or FALSE if anything went wrong
// **************************************************************************
// UseOptionList can contain additional parameters. For Java 1.4.2 they are:
//    -D<name>=<value>
//                  set a system property
//    -verbose[:class|gc|jni]
//                  enable verbose output
//    -showversion  print product version and continue
//    -ea[:<packagename>...|:<classname>]
//    -enableassertions[:<packagename>...|:<classname>]
//                  enable assertions
//    -da[:<packagename>...|:<classname>]
//    -disableassertions[:<packagename>...|:<classname>]
//                  disable assertions
//    -esa | -enablesystemassertions
//                  enable system assertions
//    -dsa | -disablesystemassertions
//                  disable system assertions
// ------------------------------------------------------------------------
//    -Xmixed           mixed mode execution (default)
//    -Xint             interpreted mode execution only
//    -Xbootclasspath:<directories and zip/jar files separated by ;>
//                      set search path for bootstrap classes and resources
//    -Xbootclasspath/a:<directories and zip/jar files separated by ;>
//                      append to end of bootstrap class path
//    -Xbootclasspath/p:<directories and zip/jar files separated by ;>
//                      prepend in front of bootstrap class path
//    -Xnoclassgc       disable class garbage collection
//    -Xincgc           enable incremental garbage collection
//    -Xloggc:<file>    log GC status to a file with time stamps
//    -Xbatch           disable background compilation
//    -Xms<size>        set initial Java heap size
//    -Xmx<size>        set maximum Java heap size
//    -Xss<size>        set java thread stack size
//    -Xprof            output cpu profiling data
//    -Xrunhprof[:help]|[:<option>=<value>, ...]
//                      perform JVMPI heap, cpu, or monitor profiling
//    -Xdebug           enable remote debugging
//    -Xfuture          enable strictest checks, anticipating future default
//    -Xrs              reduce use of OS signals by Java/VM (see documentation)
//    -Xcheck:jni       perform additional checks for JNI functions



java::start := proc( )
local classp, libp, dllp, useSecurityManager, offset,
      writeToLogFile, paramList, i, leftOperator, rightOperator, arguments;
begin
  if version()[1] = 2 then
    offset:=0;
  else
    offset:=1;
  end_if;

  // Add the matrixEditor and additional necessary classes here !
	 classp := java::classpath . java::getPath("%MUPAD_JRE_PATHMuPAD/MuPADTools.jar") . java::separator;
	 classp := classp . java::getPath("%MUPAD_JRE_PATHMuPAD/MatrixEditor.jar") . java::separator;
	 //classp := java::classpath . java::getPath("%MUPAD_JAVA_PATHclasses/MatrixEditor.jar") . java::separator;
  //print("start (1) :Classpath=".classp );
  libp := java::libpath; // The same !!!
  //print("start (2) :Libpath=".libp );
  dllp := java::dllpath;
  //print("start (3) :DLLpath=".dllp );
  useSecurityManager := TRUE; 
  writeToLogFile := FALSE; 
  paramList := null;
  
  arguments := [args()];

  for i from 1 to nops(arguments) do
  	 //print ("Argument : " , arguments[i]);
    if (type(arguments[i]) = "_equal") then 
      leftOperator := op(arguments[i],1);
      rightOperator := op(arguments[i],2);
      if leftOperator = hold(ClassPath) then
        if not rightOperator[length(rightOperator)-(1-offset)] = java::separator then
          classp := java::getPath(rightOperator) . java::separator . classp;
        else
          classp := java::getPath(rightOperator) . classp;
        end_if; 
      elif leftOperator = hold(LibraryPath) then 
        if not rightOperator[length(rightOperator)-(1-offset)] = java::separator then
          libp := java::getPath(rightOperator) . java::separator . libp;
        else
          libp := java::getPath(rightOperator) . libp;
        end_if; 
      elif leftOperator = hold(DLLPath) then 
        if sysname(hold(Arch)) = "darwin" then
          print(Unquoted, "On a MAC-OS X the JVM has to be in a specified directory. Ignoring the definition."); 
        else
          dllp := java::getPath(rightOperator);
        end_if;
      elif leftOperator = hold(UseSecurityManager) then 
        if domtype(rightOperator) = DOM_BOOL then
          useSecurityManager := rightOperator;
        else
          error("Wrong argument : " . expr2text(arguments[i]));
        end_if;
      elif leftOperator = hold(UseLogFile) then 
        if domtype(rightOperator) = DOM_BOOL then
          writeToLogFile := rightOperator;
        else
          error("Wrong argument : " . expr2text(arguments[i]));
        end_if;
      elif leftOperator = hold(UseOptionList) then 
        if domtype(rightOperator) = DOM_LIST then
	  paramList := [];
	  for j from 1 to nops(rightOperator) do
            paramList := paramList . [java::getPath(rightOperator[j])];
	  end_for;
        else
          error("Wrong argument : " . expr2text(arguments[i]));
        end_if;
      else
        error("Wrong argument : " . expr2text(arguments[i]));
      end_if;    	
    else
      error("Wrong argument : " . expr2text(arguments[i]));
    end_if;
  end_for;

  libp   := "-Djava.library.path=" . libp;
  classp := "-Djava.class.path=" . classp;

  if sysname() = "MSDOS" then
    dllp := dllp . "jvm.dll";
  elif sysname(hold(Arch)) = "linux" then
    dllp := dllp . "libjvm.so";
  elif sysname(hold(Arch)) = "Darwin" then
    dllp := dllp . "libhotspot.dylib";
  end_if;

  if paramList = null then
    java::module::start( classp, libp, dllp, useSecurityManager, writeToLogFile);
  else
    java::module::start( classp, libp, dllp, useSecurityManager, writeToLogFile, paramList);  	
  end_if;

end_proc:


