// **************************************************************************
// FUNCTION: showMatrix
// DATE    : 04 September 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1       <String> : The signature of the MuPAD representative
// **************************************************************************
// Return : null().
// **************************************************************************
java::showMatrix := proc(sign)
local oldDir, arguments, optPar, matr, retType, content;
begin

  if args(0) < 1 then
  	 error("the matrix editor accepts only one or two parameter(s).");
  end_if;

  if not domtype(sign) = DOM_STRING then
    error("No object with this name exists (Not of type DOM_STRING).");
  end_if;

  oldDir := java::callHO_getClassname(sign);
  if oldDir = null() then
    error("The requested object is not existent.");
  elif not oldDir = "taberion/Taberion" then
    error("The requested object is no matrix object.");
  end_if;

  oldDir := java::getWorkingDirectory();
  java::setWorkingDirectory(java::getPath("%MUPAD_JAVA_PATHclasses"));

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    // Since getStatus returned -1 and not 0, it has to be still in memory.
  elif (java::getStatus() = 1) then
    java::start( );
    if (java::getStatus() = -1) then
      error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    end_if;
  end_if;

  java::taberion::Taberion::setVisible(TRUE, hold(UseObject)=sign);
  
  java::setWorkingDirectory(oldDir);

  null();
end_proc:


