// **************************************************************************
// FUNCTION: showJavaInfo
// DATE    : 13 September 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1       <Int> : The number of the information requested
// **************************************************************************
// Return : the information of the JVM.
// **************************************************************************
java::showJavaInfo := proc()
local retStr, info, pp;
begin

  if args(0) = 0 then
    pp := PRETTYPRINT;
    PRETTYPRINT := FALSE;
    print(Unquoted, "Call showJavaInfo(Nr) to receive information about");
    print(Unquoted, "the virtual machine. See list for details:");
    print(Unquoted, "");
    print(Unquoted, "Nr. Description of Associated Value");
    print(Unquoted, "--- ----------------------------------------------");
    print(Unquoted, " 1  Java Runtime Environment version");
    print(Unquoted, " 2  Java Runtime Environment vendor");
    print(Unquoted, " 3  Java vendor URL");
    print(Unquoted, " 4  Java installation directory");
    print(Unquoted, " 5  Java Virtual Machine specification version");
    print(Unquoted, " 6  Java Virtual Machine specification vendor");
    print(Unquoted, " 7  Java Virtual Machine specification name");
    print(Unquoted, " 8  Java Virtual Machine implementation version");
    print(Unquoted, " 9  Java Virtual Machine implementation vendor");
    print(Unquoted, "10  Java Virtual Machine implementation name");
    print(Unquoted, "11  Java Runtime Environment specification version");
    print(Unquoted, "12  Java Runtime Environment specification vendor");
    print(Unquoted, "13  Java Runtime Environment specification name");
    print(Unquoted, "14  Java class format version number");
    print(Unquoted, "15  Java class path");
    print(Unquoted, "16  List of paths to search when loading libraries");
    print(Unquoted, "17  Default temp file path");
    print(Unquoted, "18  Name of JIT compiler to use");
    print(Unquoted, "19  Path of extension directory or directories");
    print(Unquoted, "20  Operating system name");
    print(Unquoted, "21  Operating system architecture");
    print(Unquoted, "22  Operating system version");
    print(Unquoted, "23  File separator (\"/\" on UNIX)");
    print(Unquoted, "24  Path separator (\":\" on UNIX)");
    print(Unquoted, "25  Line separator (\"\\n\" on UNIX)");
    print(Unquoted, "26  User's account name");
    print(Unquoted, "27  User's home directory");
    print(Unquoted, "28  User's current working directory");
    pp := PRETTYPRINT:
  else
   info := args(1);
   if not domtype(info) = DOM_INT then
     error("A number has to be stated.");
   end_if;

   if (java::getStatus() = -1) then
     error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
     // Since getStatus returned -1 and not 0, it has to be still in memory.
   elif (java::getStatus() = 1) then
     java::start( );
     if (java::getStatus() = -1) then
       error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
     end_if;
   end_if;

   retStr := java::MuPADHelper::getSystemInformation(info);

   return (retStr);
  end_if;

  null()
end_proc:


