// **************************************************************************
// FUNCTION: setWorkingDirectory
// DATE    : 17 Juni 2003
// MuPAD   : Version 3.0.0 / 2.5.2
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1        <String> : The new working directory for java
// **************************************************************************
// Sets the current java working directory.
// **************************************************************************
// Return : The new directory as String.
// **************************************************************************
java::setWorkingDirectory := proc( theDir )
local retValue;
begin

  if not domtype(theDir) = DOM_STRING then
    error ("Directory must be given as string representation.\n");
  end_if;


  if (java::module::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    // Since getStatus returned -1 and not 0, it has to be still in memory.
  elif (java::module::getStatus() = 1) then
    java::start(  );
    if (java::module::getStatus() = -1) then
      error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    end_if;
  end_if;
  
  retValue := java::getWorkingDirectory();
  java::setJavaKey(28, java::getPath(theDir));
  retValue;
end_proc:


