// **************************************************************************
// FUNCTION: setJavaKey
// DATE    : 15 September 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1       <Int> : The number of the information to be changed
// Parameter 2       <Int> : The new value
// **************************************************************************
// Return : null.
// **************************************************************************
java::setJavaKey := proc()
local retStr, info, pp, value;
begin

  if not args(0) = 2 then
  	 error("2 parameters neccessary. (Key, Keyvalue)");
  end_if;

  info := args(1);
  if not domtype(info) = DOM_INT then
    error("A number has to be stated.");
  end_if;

  value := args(2);
  if not domtype(value) = DOM_STRING then
    error("The key itself has to be of type string.");
  end_if;

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    // Since getStatus returned -1 and not 0, it has to be still in memory.
  elif (java::getStatus() = 1) then
    java::start( );
    if (java::getStatus() = -1) then
      error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    end_if;
  end_if;

  java::MuPADHelper::setSystemInformation(info, value);

  null()
end_proc:


