// **************************************************************************
// FUNCTION: runApplet
// DATE    : 17 September 2003
// MuPAD   : Version 3.0.0 / 2.5.2
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1          <Applet> : The applet to be used (coded as MuPAD_...)
// optional Parameter 2 <List>   : The list containing the arguments.
// Options  <Expr>   : Width = appletwidth
//          <Expr>   : Height = appletheight
// **************************************************************************
// Sets the current java working directory.
// **************************************************************************
// Return : The new directory as String.
// **************************************************************************
java::runApplet := proc( theApplet )
local retValue, arguments, argument, i, leftOperator, rightOperator, height, width;
begin

  if not domtype(theApplet) = DOM_STRING then
    error ("Parameter must be a valid MuPAD object representative.\n");
  end_if;

  if args(0) = 2 then
    arguments := args(2);
    if not domtype(arguments) = DOM_LIST then
      error ("Arguments must be handed as list of strings !.\n");
    end_if;  
  else arguments := [];	
  end_if; 

  width  := 640;
  height := 480;
  
  for i from 3 to args(0) do
    argument := args(i);
    if (type(argument) = "_equal") then 
      leftOperator := op(argument, 1);
      rightOperator := op(argument, 2);
      if leftOperator = hold(Width) then 
        if not domtype(rightOperator) = DOM_INT then
          error("An integer number has to be used for parameter Width");
        else
          width := rightOperator;
        end_if;
      elif leftOperator = hold(Height) then
        if not domtype(rightOperator) = DOM_INT then
          error("An integer number has to be used for parameter Height");
        else
          height := rightOperator;
        end_if;
      end_if;
    else
      error("Options have to be equations (Ex.: Width=640)");
    end_if;
  end_for;

  retValue := java::AppletStarter::AppletStarter(theApplet, arguments, width, height)

end_proc:


