// **************************************************************************
// FUNCTION: matrixEditor
// DATE    : 04 September 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1       <List> : matrix (string / integer / floating point)
//                   or
//                   <integer>      : number of rows and columns
// optional Parameter <Ident>       : Matrix  | <List>
// optional Parameter <Ident>       : <Modal> | NonModal
// **************************************************************************
// Return : A two dimensional squared list of string / integer / floating point.
// **************************************************************************
java::matrixEditor := proc()
local oldDir, argument, arguments, optPar, matr, matr2, retType, modal, matrType, width, height;
begin

  if args(0) < 1 then
  	 error("At least one parameter has to be stated.");
  end_if;

  retType  := hold(Matrix);
  modal    := hold(Modal);

  arguments := args(0);
  argument := args(1);

  if (domtype(argument) = DOM_LIST) then
    matr := matrix(argument);
    //if (op(matr::dom::matdim(matr),1) <> op(matr::dom::matdim(matr),2)) then
 	  //	 error("the number of rows and columns must be identical.");
    //end_if;
  elif (domtype(argument) = Dom::Matrix()) then
    matr := argument;
    //if (op(matr::dom::matdim(matr),1) <> op(matr::dom::matdim(matr),2)) then
 	  //	 error("the matrix must be squared.");
    //end_if;
    argument := matr::dom::convert_to(matr, DOM_LIST);
  elif (domtype(argument) = DOM_INT) then
    width := argument; height := argument;
    if args(0) > 1 then
      if (domtype(args(2)) = DOM_INT) then
        height := args(2);    	
      end_if;    	
    end_if;
    matr := matrix(width, height);
    argument := matr::dom::convert_to(matr, DOM_LIST);
  else
  	 error("the matrix editor has to be invoked with either a number, a matrix, or a list of lists.");
  end_if;

  for i from 2 to args(0) do
  	 optPar := args(i);
    
    if (domtype(optPar) = DOM_IDENT) then 
       case optPar
         of hold(Matrix) do break;
         of hold(List) do retType := hold(List); break;
         of hold(Modal) do break;
         of hold(NonModal) do modal := hold(NonModal); break;
         otherwise
           error("Optional parameter has to be Matrix | <List> | <Modal> | NonModal");
       end_case;
    elif (domtype(optPar) = DOM_INT) then 
      // nothing
    else
      error("Optional parameter has to be Matrix | <List> | <Modal> | NonModal");
    end_if;    	
  end_for;

  oldDir := java::getWorkingDirectory();
  java::setWorkingDirectory(java::getPath("%MUPAD_JAVA_PATHclasses"));

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    // Since getStatus returned -1 and not 0, it has to be still in memory.
  elif (java::getStatus() = 1) then
    java::start( );
    if (java::getStatus() = -1) then
      error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    end_if;
  end_if;

  matr2 := argument;
  if modal = hold(NonModal) then
    matr := java::taberion::Taberion::Taberion(argument, FALSE);
    java::setWorkingDirectory(oldDir);
  else
    // Start Taberion
    matr := java::taberion::Taberion::Taberion(argument, TRUE);
    // Take care that it will only return if any button is pressed.
    java::taberion::Taberion::waitForReturn(hold(UseObject)=matr);
    // get the type of the matrix:
    matrType := java::taberion::Taberion::getDataType(hold(UseObject)=matr);
    //print(Unquoted, "The return type is " . matrType);
    // Now get the apropriate matrix:
    if matrType = -1 then
      matr := NULL;
    elif matrType = 0 then
      // string
      matr := java::taberion::Taberion::getStringMatrix(hold(UseObject)=matr);    	
    elif matrType = 1 then
      // BigInteger
      matr := java::taberion::Taberion::getIntegerMatrix(hold(UseObject)=matr);    	
    elif matrType = 2 then
      // BigDecimal
      matr := java::taberion::Taberion::getFloatingPointMatrix(hold(UseObject)=matr);
    end_if;


    //matr := java::taberion::Taberion::matrixEditor(argument);
    java::setWorkingDirectory(oldDir);

    if matr = NULL then
      print (Unquoted, "Aborted by the user. Returning original data.");
      matr := matr2;
    end_if;

    if retType = hold(Matrix) then
      return (matrix(matr));
    else
      return (matr);
    end_if;
  end_if;

  // Whatever the invocation returns, return it, too. (An object representative.)
  // if state was non modal the representative will be returned
  // if state was modal, the matrix will be returned according to the settings.
  matr;
end_proc:


