// **************************************************************************
// FUNCTION: listMethods
// DATE    : 17 Juni 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// optional Parameter <int>    : A number between 1 and 4
// optional Parameter <Expr>   : Match = <Max> | Best | First | Native
//
// 1 = first match  : take the first possible method out of the array.
// 2 = max match    : use a ranking system to rank the methods:
//                    Integer        : BigInteger = 5, Long = 4, 
//                                     Int = 3, Short = 2, Byte = 1
//                    Floating point : BigDecimal = 3, Double = 2, 
//                                     Float = 1
//                    Text           : String = 2, Char = 1
// 3 = best match   : use the parameter with the smallest deviation 
//                    to the request
//                    transfer numbers and check the size. According 
//                    to the size use the next smallest possible java 
//                    type
// **************************************************************************
// Return : The new value if a match was stated, or the current matching if
//          no number was stated.
// **************************************************************************
java::match := proc()
local arguments, match, leftOperator, rightOperator;

begin
  arguments := [args()];
  if (nops(args()) = 0) then
    match := java::module::match();
  else
    if (type(arguments[1]) = "_equal") then 
      leftOperator := op(arguments[1],1);
      rightOperator := op(arguments[1],2);
      if leftOperator = hold(Match) then 
        case rightOperator
          of hold(First)  do match := 1; break;
          of hold(Max)    do match := 2; break;
          of hold(Best)   do match := 3; break;
          otherwise
            error("Wrong right hand argument for Match (First, Max, Best) : " . expr2text(rightOperator));
        end_case;
      else
        error("Wrong argument : " . expr2text(arguments[1]));
      end_if;    	
    elif (domtype(arguments[1]) = DOM_INT) then
      match := arguments[1];
    else
      error("Wrong argument : " . expr2text(arguments[1]));
    end_if;
    match := java::module::match(match);  
  end_if;

  match;
end_proc:


