// **************************************************************************
// FUNCTION: list
// DATE    : 17 Juni 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1        <String> : Classname
// optional Parameter <Expr>   : AccessSpecifier = Private | Protected | <Public>
// optional Parameter <Expr>   : ReturnOnly = <All> | Constructors | Methods | Fields
// optional Parameter <Ident>  : ShowInJava 
// optional Parameter <Ident>  : ShowInMuPAD
// optional Parameter <Ident>  : ReturnList  
// **************************************************************************
// Default behavior if ShowInJava was activated : No list will be returned
// Default behavior if ShowInMuPad was activated : No list will be returned
// **************************************************************************
// Return : Either a list containing three lists [[constructors],[methods],[fields]]
//          or as defined.
// **************************************************************************
java::list := proc(classname)
local arguments, i, callList, accessSpecifier, showInJava, showInMuPAD, returnList, retOnly, prepr, offset, oldDir, setExplicit;
begin

  if version()[1] = 2 then
     offset:=0;
     else
     offset:=1;
  end_if;

  if not domtype(classname) = DOM_STRING then
    error ("Classname must be of type String.\n");
  end_if;


  prepr := PRETTYPRINT;
  PRETTYPRINT := FALSE;

  //Predefinitions
  showInJava      := FALSE;
  showInMuPAD     := FALSE;
  accessSpecifier := 1;     // Public
  returnList      := TRUE;
  setExplicit     := FALSE;
  retOnly         := hold(All);
  oldDir          := java::getWorkingDirectory();
  
  java::setWorkingDirectory(java::getPath("%MUPAD_JAVA_PATHclasses"));

  arguments := args();

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    // Since getStatus returned -1 and not 0, it has to be still in memory.
  elif (java::getStatus() = 1) then
    java::start();
    if (java::getStatus() = -1) then
      error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    end_if;
  end_if;

  for i from 2 to nops(arguments) do
  	 //print ("Argument : " , arguments[i]);
    if (type(arguments[i]) = "_equal") then 
      leftOperator := op(arguments[i],1);
      rightOperator := op(arguments[i],2);
      if leftOperator = hold(AccessSpecifier) then 
        case rightOperator
          of hold(Private)   do accessSpecifier := 4; break;
          of hold(Protected) do accessSpecifier := 2; break;
          of hold(Public)    do accessSpecifier := 1; break;
          otherwise
            error("Wrong right hand argument for AccessSpecifier (Private, Protected, Public) : " . expr2text(rightOperator));
        end_case;
      elif leftOperator = hold(ReturnOnly) then 
        case rightOperator
          of hold(All)          do break;
          of hold(Constructors) do retOnly := hold(Constructors); break;
          of hold(Methods)      do retOnly := hold(Methods); break;
          of hold(Fields)       do retOnly := hold(Fields); break;
          otherwise
            error("Wrong right hand argument for AccessSpecifier (Private, Protected, Public) : " . expr2text(rightOperator));
        end_case;
      else
        error("Wrong argument : " . expr2text(arguments[i]));
      end_if;    	
    else
      leftOperator := op(arguments[i]);
      if leftOperator = hold(ShowInJava) then
        showInJava := TRUE;
        if not setExplicit then
         	returnList := FALSE;
        end_if;
      elif leftOperator = hold(ShowInMuPAD) then
        showInMuPAD := TRUE;
        if not setExplicit then
         	returnList := FALSE;
        end_if;
      elif leftOperator = hold(ReturnList) then
        setExplicit := TRUE;
        returnList := TRUE; 
      else
        error("Wrong argument : " . expr2text(arguments[i]));
      end_if;
    end_if;
  end_for;

  mupList := java::module::list(classname);

  if mupList = FAIL then
  	 error("Could not list class methods.")
  end_if;

  constructorList := op(mupList, 1);

  //methodList      := op(mupList, 2);
  methodList      := {op(op(mupList, 2))} union {op(op(mupList, 4))};
  methodList      := [op(methodList)];

  //fieldList       := op(mupList, 3);
  fieldList       := {op(op(mupList, 3))} union {op(op(mupList, 5))};
  fieldList       := [op(fieldList)];

  if (accessSpecifier = 1 or accessSpecifier = 2) then
    // remove all private things
    methodList := select( methodList, (s)-> not substring(s, offset, 7)="private" );
    fieldList := select( fieldList, (s)-> not substring(s, offset, 7)="private" );
  end_if;

  if (accessSpecifier = 1) then
    // remove everything that is not public (also package-dependencies !)
    methodList := select( methodList, (s)-> substring(s, offset, 6)="public" );
    fieldList := select( fieldList, (s)-> substring(s, offset, 6)="public" );
  end_if;

  if nops(constructorList) = 0 then
  	 constructorList := [""]
  end_if;
  if nops(methodList) = 0 then
  	 methodList := [""]
  end_if;
  if nops(fieldList) = 0 then
  	 fieldList := [""]
  end_if;

  // Now assign the lists again.
  mupList := [constructorList, methodList, fieldList];

  if showInJava then
    java::Lister::listClasses(constructorList, methodList, fieldList);
  end_if;

  if showInMuPAD then
    if retOnly = hold(All) or retOnly = hold(Constructors) then
      print (Unquoted, "Number of constructors : " . nops(constructorList));    	
    end_if;
    if retOnly = hold(All) or retOnly = hold(Methods) then
    print (Unquoted, "Number of methods      : " . nops(methodList));
    end_if;
    if retOnly = hold(All) or retOnly = hold(Fields) then
      print (Unquoted, "Number of fields       : " . nops(fieldList));
    end_if;
	   print (Unquoted, "");
    if retOnly = hold(All) or retOnly = hold(Constructors) then
      for i from 1 to nops(constructorList) do
        print (Unquoted, op(constructorList, i));    	
      end_for;
      print (Unquoted, "");
    end_if;
    if retOnly = hold(All) or retOnly = hold(Methods) then
      for i from 1 to nops(methodList) do
        print (Unquoted, op(methodList, i));    	
      end_for;
      print (Unquoted, "");
    end_if;
    if retOnly = hold(All) or retOnly = hold(Fields) then
      for i from 1 to nops(fieldList) do
        print (Unquoted, op(fieldList, i));    	
      end_for;
    end_if;
  end_if;

  PRETTYPRINT := prepr;
  java::setWorkingDirectory(oldDir);

  if returnList then
    case retOnly
      of hold(All)          do return (mupList);
      of hold(Constructors) do return (constructorList);
      of hold(Methods)      do return (methodList);
      of hold(Fields)       do return (fieldList);
    end_case;    	
    // Can never be reached (but just in case...)
    return (mupList);
  else
    null();
  end_if;
end_proc:


