// **************************************************************************
// FUNCTION: invoke
// DATE    : 2003-06-18
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1        <String> : Invokation
//
// This Invokation looks like: java::(Class1::...::Classn)::Method({Param_1, ..., Param_n} {,Options})
// IMPORTANT : A class can be divided into several pieces like use::Prog2 
// {Param_1 ... Param_n} : parameters neccesary to invoke the java method
// {Options} can be none or several of the following
//           <Expr>   : Match = First | <Max> | Best | Native
//           <Expr>   : Signature = <Signature of the java method>
//           <Ident>  : ShowMethod = TRUE | <FALSE>
// **************************************************************************
// Return : The result of the java-method (converted to MuPAD datatypes)
// **************************************************************************
java::invoke := proc( )
local compName, className, lastClassName, methName, match, signature, arguments, j, i, 
      showMethod, offset, lastSlash, indexList, isConstructor, useObject, possibleMatches, 
      invokeObject, retValue;
begin

  sysassign(java::isObject, FALSE);
  sysassign(java::objName,"");

  if version()[1] = 2 then
     offset:=0;
     else
     offset:=1;
  end_if;

  //  1 = not initialized
  //  0 = running
  // -1 = was terminated abnormally
  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    // Since getStatus returned -1 and not 0, it has to be still in memory.
  elif (java::getStatus() = 1) then
    java::start();
    if (java::getStatus() = -1) then
      error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    end_if;
  end_if;
  
  // This way it can not happen that someone uses Native as default and does not state a signature.
  match := java::match();
  signature := NULL;
  showMethod := FALSE;
  useObject := "";
  invokeObject := FALSE;
  result := "";

  compName := stringlib::subs(expr2text(args(1)), "::"="/");
  compName := stringlib::subs(compName, "java/"="", First);
  //print ("compName : " . compName);
  if (nops(stringlib::contains(compName, "/", IndexList)) = 0) then
  	 error("You must state a class to use.\n(java::Class::Method(param 1, ..., param n)");
  end_if;
  indexList := stringlib::contains(compName, "/", IndexList);
  lastSlash := indexList[nops(indexList)];
  //print ("firstSlash : " . firstSlash);
  className := substring(compName, offset, lastSlash-offset);
  //print ("className : " . className);
  methName := substring(compName, lastSlash + 1, length(compName) - lastSlash - (1-offset));

  indexList := stringlib::contains(className, "/", IndexList);
  if not (nops(indexList) = 0) then
    lastSlash := indexList[nops(indexList)];
    lastClassName := substring(className, lastSlash + 1, length(className) - lastSlash - (1-offset));
  else
    if className = methName then
    	lastClassName := className;
    else
      // does not matter !!!
      lastClassName := "";
    end_if;
  end_if;

  if lastClassName = methName then
  	 isConstructor := TRUE;
    methName := stringlib::subs(className, "/"=".");
  else
  	 isConstructor := FALSE;
  end_if;

  //print ("methName : " . methName);
  arguments := [args()];
  delete arguments[1];
	 //print ("Arguments : " . expr2text(arguments));
	 //print ("Argument number : " . nops(arguments));
  i := 1;
  for j from 1 to nops(arguments) do
  	 //print ("Argument : " , arguments[i]);
    if (type(arguments[i]) = "_equal") then 
      leftOperator := op(arguments[i],1);
      rightOperator := op(arguments[i],2);
      if leftOperator = hold(Match) then 
        delete arguments[i];
        // If the chosen method should always be displayed when a matching was stated,
        // just uncomment the next line.
        // showMethod := TRUE;
        case rightOperator
          of hold(First)  do match := 1; break;
          of hold(Max)    do match := 2; break;
          of hold(Best)   do match := 3; break;
          of hold(Native) do match := 4; break;
          otherwise
            error("Wrong right hand argument for match (First, Best, Max, Native) : " . expr2text(rightOperator));
        end_case;
      elif leftOperator = hold(Signature) then
        delete arguments[i];
        signature := op(rightOperator);
      elif leftOperator = hold(ShowMethod) then 
        delete arguments[i];
        showMethod := op(rightOperator);
      elif leftOperator = hold(UseObject) then 
        delete arguments[i];
        useObject := op(rightOperator);
        className := java::callHO_getClassname(useObject);
        if className = null() then
        	 error("The requested object is not existent.");
        end_if;
        invokeObject := TRUE;
        isConstructor := FALSE;
      end_if;    	
    else
      i := i + 1;
    end_if;
  end_for;

  if ((match = 4) and (signature = NULL)) then
    error("Native search expects a signature.");
  end_if;

  // If a signature is stated, the native check is forced.
  //if ((not (signature = NULL)) and (not (match = 4))) then
  //  match := 4;  	
  //end_if;

  // If a signature is stated and Match != native, then throw away signature.
  if ((not (signature = NULL)) and (not (match = 4))) then
    signature := NULL;  	
  end_if;

  if (isConstructor and ((match = 1) or (match = 2))) then
  	 match := 3;
  end_if;

  // get a list with possible matches.
  possibleMatches := java::checkForMatches(arguments);

  if ((match = NULL) and (signature = NULL)) then
    retValue := java::module::invoke( className, methName, arguments, showMethod, isConstructor , invokeObject, useObject, possibleMatches);
  elif ( (match = NULL) and (not (signature = NULL)) ) then
    retValue := java::module::invoke( className, methName, arguments, showMethod, isConstructor, invokeObject, useObject, possibleMatches, signature);
  elif ((not (match = NULL)) and (signature = NULL)) then
    retValue := java::module::invoke( className, methName, arguments, showMethod, isConstructor, invokeObject, useObject, possibleMatches, match);
  else
    retValue := java::module::invoke( className, methName, arguments, showMethod, isConstructor, invokeObject, useObject, possibleMatches, match, signature);
  end_if;
  

end_proc:


