// **************************************************************************
// FUNCTION: getPath
// DATE    : 27 Juni 2003
// MuPAD   : Version 2.5.2 / 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// optional Parameter 1 <String> : key
// **************************************************************************
// Return : The path fitting to the key or an empty string if key is not found.
// **************************************************************************

java::getPath := proc( theKey )
begin

  if not domtype(theKey) = DOM_STRING then
    error ("Directory must be given as string representation.\n");
  end_if;

  replacePlaceHolders := proc( toReplace )
  local newString, longPath, deleteAdditional, placeHolder, mupPath;
  begin
    longPath := java::javaRootPath;
    mupPath := module::which("stdmod");
    if sysname() = "MSDOS" then
      //print(Unquoted, "Using MSDOS/Windows...");
      // remove modules\stdmod.mdm
      placeHolder := "\\";
      mupPath := stringlib::remove(mupPath, "modules\\stdmod.mdm");
    elif sysname() = "UNIX" then
      //print(Unquoted, "Using UNIX...");
      placeHolder := "/";
      mupPath := stringlib::remove(mupPath, "modules/stdmod.mdm");
      if sysname(Arch) = "UNIX" then
        mupPath := stringlib::remove(mupPath, "UNIX/");
      else
        mupPath := stringlib::remove(mupPath, "linux/");
      end_if;
    elif sysname() = "MACOS" then
      //print(Unquoted, "Using MACOS...");
      // remove modules\stdmod.mdm
      placeHolder := "/";
      mupPath := stringlib::remove(mupPath, "MACOS\\modules\\stdmod.mdm");
    end_if;

    newString := stringlib::subs(toReplace, "%MUPAD_JRE_PATH" = "%MUPAD_JAVA_PATHjavart/");
    newString := stringlib::subs(newString, "%MUPAD_JAVA_PATH" = longPath);
    newString := stringlib::subs(newString, "%MUPAD_PATH" = mupPath);
    if placeHolder = "/" then
      newString := stringlib::subs(newString, "\\" = "/");
    else
      newString := stringlib::subs(newString, "/" = "\\");
    end_if;

    newString;
  end_proc:

  replacePlaceHolders(theKey);

end_proc:


