// **************************************************************************
// FUNCTION: getMatrix
// DATE    : 04 September 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1       <String> : The signature of the MuPAD representative
// optional Parameter <Ident> : Integer | <FloatingPoint> | String
// optional Parameter <Ident> : List    | <Matrix>
// **************************************************************************
// Return : A two dimensional squared list or matrix of string / integer / floating point.
// **************************************************************************
java::getMatrix := proc(sign)
local oldDir, arguments, optPar, matr, retType, content;
begin

  if args(0) < 1 then
  	 error("the matrix editor accepts only one or two parameter(s).");
  end_if;

  retType  := hold(FloatingPoint);
  content := hold(Matrix);

  if not domtype(sign) = DOM_STRING then
    error("No object with this name exists (Not of type DOM_STRING).");
  end_if;

  oldDir := java::callHO_getClassname(sign);
  if oldDir = null() then
    error("The requested object is not existent.");
  elif not oldDir = "taberion/Taberion" then
    error("The requested object is no matrix object.");
  end_if;

  for i from 2 to args(0) do
  	 optPar := args(i);
    if (domtype(optPar) = DOM_IDENT) then 
       case optPar
         of hold(Integer) do retType := hold(Integer); break;
         of hold(String) do retType := hold(String); break;
         of hold(FloatingPoint) do break;
         of hold(Matrix) do break;
         of hold(List) do content := hold(List); break;
         otherwise
           error("Optional parameter has to be Matrix | <List> | Integer | <FloatingPoint> | String");
       end_case;
    else
      error("Optional parameter has to be Matrix | <List> | Integer | <FloatingPoint> | String");
    end_if;    	
  end_for;

  oldDir := java::getWorkingDirectory();
  java::setWorkingDirectory(java::getPath("%MUPAD_JAVA_PATHclasses"));

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    // Since getStatus returned -1 and not 0, it has to be still in memory.
  elif (java::getStatus() = 1) then
    java::start( hold(ClassPath)=java::classpath, hold(LibraryPath)=java::libpath, hold(DLLPath)=java::dllpath );
    if (java::getStatus() = -1) then
      error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    end_if;
  end_if;

  // get the matrix
  if retType = hold(Integer) then
    matr := java::taberion::Taberion::getIntegerMatrix(hold(UseObject)=sign);
  elif retType = hold(String) then
    matr := java::taberion::Taberion::getStringMatrix(hold(UseObject)=sign);
  else
    matr := java::taberion::Taberion::getFloatingPointMatrix(hold(UseObject)=sign);
  end_if;

  java::setWorkingDirectory(oldDir);

  if content = hold(Matrix) then
    return (matrix(matr));
  else
    return (matr);
  end_if;

end_proc:


