// **************************************************************************
// FUNCTION: createInterface
// DATE    : 01 October 2003
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1        <Ident> : domainName
// **************************************************************************
// Return : a set of method names wrapped in the hold command.
// **************************************************************************
java::createInterface := proc(domainName)
local argument, returnSet, offset, mupList, mName, returnSet2, pos1, pos2;
begin

  if version()[1] = 2 then
     offset:=0;
     else
     offset:=1;
  end_if;

  argument := expr2text(args());

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    // Since getStatus returned -1 and not 0, it has to be still in memory.
  elif (java::getStatus() = 1) then
    java::start();
    if (java::getStatus() = -1) then
      error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
    end_if;
  end_if;

  // parse domainname to remove "java" and replace file separators.
  argument := stringlib::subs(argument, "java::"="", First);
  argument := stringlib::subs(argument, "::"="/");

  java::module::setShowErrors(FALSE);
  mupList := java::module::list(argument);
  java::module::setShowErrors(TRUE);

  returnSet2 := {};

  if not mupList = FAIL then
    returnSet := {op(op(mupList, 1))} union {op(op(mupList, 2))} union {op(op(mupList, 4))};
    returnSet := select( returnSet, (s)-> substring(s, offset, 6)="public" );
    for mName in returnSet do
      pos2 := stringlib::contains(mName, "(", Index)-1;
      // now backwards until a . (dot) appears
      pos1 := offset; // just in case.

      for i from pos2 downto offset do
        // "." for usual methods
        // " " for constructors
      	 if substring(mName,i,1) = "." or substring(mName,i,1) = " " then
      	 	 pos1 := i+1;
          break;
      	 end_if;
      end_for;
      mName := substring(mName, pos1, (pos2 - pos1 + 1));
      returnSet2 := returnSet2 union {text2expr(mName)};
    end_for;
  else
   // It is a directory or not known. So in the future one might want to create 
   // a list of possible classes right here...
  end_if;

  returnSet2;

end_proc:


