// **************************************************************************
// FUNCTION: checkNumber
// DATE    : 01 September 2003
// MuPAD   : Version 2.5.2 / 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1 <number> : The number that is to be compared
// Parameter 2 <number> : 0 = byte
//                        1 = short
//                        2 = integer
//                        3 = long
//                        4 = float
//                        5 = double
// **************************************************************************
// Return : TRUE if the number is between the bounds, FALSE otherwise.
// **************************************************************************

java::checkNumber := proc( number1 : DOM_INT, number2 : DOM_INT )
begin

 // print(Unquoted, expr2text(number1));
 // print(Unquoted, expr2text(number2));

  if (number2 = 0) then 
    // byte
    if (number1 >= -128) and (number1 <= 127) then
    	 return (TRUE);
    end_if;
  elif (number2 = 1) then
    // short
    if (number1 >= -32768) and (number1 <= 32767) then
    	 return (TRUE);
    end_if;
  elif (number2 = 2) then
    // integer
    if (number1 >= -2147483648) and (number1 <= 2147483647) then
    	 return (TRUE);
    end_if;
  elif (number2 = 3) then
    // long
    if (number1 >= -9223372036854775808) and (number1 <= 9223372036854775807) then
    	 return (TRUE);
    end_if;
  elif (number2 = 4) then
    // float 
    if (number1 >= -1.4e45) and (number1 <= 3.4028235e38) then
    	 return (TRUE);
    end_if;
  elif (number2 = 5) then
    // double
    if (number1 >= -4.9e324) and (number1 <= 1.7976931348623157e308) then
    	 return (TRUE);
    end_if;
  end_if;

  FALSE;

end_proc:


