// **************************************************************************
// FUNCTION: checkForMatches
// DATE    : 2003-09-14
// MuPAD   : Version 3.0.0
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1        <List> : The list with the arguments
// **************************************************************************
// Return : A list containing the possible data types for each parameter.
// **************************************************************************
// The following constants were taken directly out of reflect.cpp
// JAVA_BOOLEAN      1
// JAVA_CHAR         2
// JAVA_BYTE         3
// JAVA_SHORT        4
// JAVA_INT          5
// JAVA_LONG         6
// JAVA_FLOAT        7
// JAVA_DOUBLE       8
// JAVA_BIGINTEGER  11
// JAVA_BIGDECIMAL  12
// JAVA_STRING      13
// JAVA_UNKNOWN     21
// JAVA_OBJECT      22
// JAVA_ARRAY      100

java::checkForMatches := proc( )
local i, j, arguments, argument, listDepth, dummyList1, domTypes, 
      maxNumber, minNumber, isChar, returnList, paramList, offset,
      firstSet, secondSet;
begin

  if version()[1] = 2 then
    offset:=0;
  else
    offset:=1;
  end_if;

  if not nops(args(0)) = 1 then
  	 error("A list containing the arguments has to be stated.");
  end_if;

  arguments := args(1);
  if not domtype(arguments) = DOM_LIST then
  	 error("A list containing the arguments has to be stated.");
  end_if;

  returnList := [];

  for i from 1 to nops(arguments) do
    argument := arguments[i];
    listDepth := 0;
    if domtype(argument) = DOM_LIST then
      j := argument;  
      while domtype(j) = DOM_LIST do
      	 j := op(j, 1);
        listDepth := listDepth + 1;
      end_while;
      // Calculate depth and get the basic informations
      repeat
        dummyList1 := argument;
        if (offset = 0) and (argument = []) then
          // Do NOTHING !
          // Necessary, because map crashes on 2.5 in a single list !
        else
          argument  := _union(map(op(argument), x->{op(x)}));
        end_if;
      until dummyList1 = argument end:
    end_if;
  
    maxNumber := 0;
    minNumber := 0;
    firstSet := {};
    secondSet := {};
    paramList := [];

    // Now we have either a solitary data type or a set of data types.
    if nops(argument) = 0 then
      // Empty list, so it can be everything.
      j := listDepth * 100;
      paramList := [j+1,j+2,j+3,j+4,j+5,j+6,j+7,j+8,j+11,j+12,j+13,j+21,j+22];
    else
     if domtype(argument) = DOM_SET then
       domTypes := domtype(op(argument,1)); // just for comparing purposes.
       // later the possible numbers will be found out using these two parameters.
       // To do so, first the least and then the highest number will be checked.
       // Afterwards the numbers that match in both lists will be returned.
       // Ex.: maxNumber = [2,3,4], minNumber = [3,4] => result = [3,4]
       if domTypes = DOM_BOOL then
         for j in argument do
           if not domtype(j) = domTypes then
             error("The elements in the list are not of same type.")
           end_if;
         end_for;
         paramList := [(listDepth * 100) + 1];
       elif domTypes = DOM_STRING then       
         // check if it is an object (then all have to be objects)
         //if (length(argument[1]) > 10) and (substring(argument[1],offset,10) = "MuPAD_JNI_") then
         //  paramList := [(listDepth * 100) + 13, (listDepth * 100) + 21, (listDepth * 100) + 22]
         //else // non must be an object.
           isChar := TRUE;
           for j in argument do
             if not domtype(j) = domTypes then
               error("The elements in the list are not of same type.")
             end_if;
             if length(j) > 1 then
               isChar := FALSE;
             end_if;
           end_for;

           // The object was added since @NULL might be stated and it has to be detected.
           // Char can not be an object !
           // Objects will be replaced on the native side !
           if isChar then
             paramList := [(listDepth * 100) + 2, (listDepth * 100) + 13]
           else
             paramList := [(listDepth * 100) + 13, (listDepth * 100) + 21, (listDepth * 100) + 22]
           end_if;
         //end_if;       
       else // has to be a number
         // Check every element
         for j in argument do
           if not domtype(j) = domTypes then
             error("The elements in the list are not of same type.")
           end_if;
           if j > maxNumber then
             maxNumber := j;
           end_if;
           if j < minNumber then
             minNumber := j;
           end_if;
         end_for; 
         // Now we have the lowest and the highest value and the data type (float, int)
         if domTypes = DOM_INT then
           for j from 0 to 3 do
             if java::checkNumber(minNumber, j) then
               firstSet := firstSet union {(listDepth * 100)+j+3};
             end_if;
             if java::checkNumber(maxNumber, j) then
               secondSet := secondSet union {(listDepth * 100)+j+3};
             end_if;
           end_for;
         	 firstSet := firstSet union {(listDepth * 100)+11}; // BigInteger always works
         	 secondSet := secondSet union {(listDepth * 100)+11}; // BigInteger always works
         else
           for j from 4 to 5 do
             if java::checkNumber(minNumber, j) then
               firstSet := firstSet union {(listDepth * 100)+j+3};
             end_if;
             if java::checkNumber(maxNumber, j) then
               secondSet := secondSet union {(listDepth * 100)+j+3};
             end_if;
           end_for;
         	 firstSet := firstSet union {(listDepth * 100)+12}; // BigDecimal always works
         	 secondSet := secondSet union {(listDepth * 100)+12}; // BigDecimal always works
         end_if;
         // Now intersect the two lists
         firstSet := firstSet intersect secondSet;
         paramList := [op(firstSet)];
       end_if; // not domTypes = DOM_STRING
     else
       // No set. Single value.
       if domtype(argument) = DOM_BOOL then
         paramList := [1];
       elif domtype(argument) = DOM_STRING then
         if length(argument) = 1 then
  	        paramList := [2,13];
         else
           if argument = "@NULL" then
    	        paramList := [22];
           elif (length(argument) > 10) and (substring(argument,offset,10) = "@MuPAD_JNI") then
    	        paramList := [21];
           else
    	        paramList := [13];
           end_if;
         end_if;
       elif domtype(argument) = DOM_INT then
         for j from 0 to 3 do
           if java::checkNumber(argument, j) then
             firstSet := firstSet union {j+3};
           end_if;
         end_for;
       	 firstSet := firstSet union {11}; // BigInteger always works
         paramList := [op(firstSet)];
       elif domtype(argument) = DOM_FLOAT then
         for j from 4 to 5 do
           if java::checkNumber(argument, j) then
             firstSet := firstSet union {j+3};
           end_if;
         end_for;
       	 firstSet := firstSet union {12}; // BigDecimal always works
         paramList := [op(firstSet)];
       else
         error("The data type you stated can not be converted: " . expr2text(domtype(argument)));
       end_if;
     end_if; // domytype(argument) = DOM_SET
   end_if; // nops(argument) = 0

   returnList := append(returnList, paramList);

  end_for;

  returnList;

end_proc:


