// **************************************************************************
// FUNCTION: callHO_removeObject
// DATE    : 17 Juni 2003
// MuPAD   : Version 3.0.0 / 2.5.2
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1        <String> : The mupad signature of the object
//
// **************************************************************************
// Removes the object with the stated signature from the list of stored
// Java objects.
// **************************************************************************
// Return : Nothing.
// **************************************************************************
java::callHO_removeObject := proc( sign )
begin

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
  end_if;

  if not domtype(sign) = DOM_STRING then
    error ("No correct signature was given.\n");
  end_if;

  java::module::callHO_removeObject(sign);
  null();
end_proc:


