// **************************************************************************
// FUNCTION: callHO_getSignature
// DATE    : 17 Juni 2003
// MuPAD   : Version 3.0.0 / 2.5.2
// AUTHOR  : Jrn Maas
// **************************************************************************
// Parameter 1        <String> : The mupad signature of the object
// **************************************************************************
// Gets the java representative signature of an object.
// **************************************************************************
// Return : The java representative signature of the object.
// **************************************************************************
java::callHO_getSignature := proc( sign )
local retValue;
begin

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
  end_if;

  if not domtype(sign) = DOM_STRING then
    return (null());
  end_if;

  retValue := java::module::callHO_getSignature(sign); 
  return (retValue);
end_proc:


