// **************************************************************************
// FUNCTION: callHO_showList
// DATE    : 16 August 2003
// MuPAD   : Version 3.0.0 / 2.5.2
// AUTHOR  : Jrn Maas
// **************************************************************************
// optional Parameter <Ident>  : ShowInJava   <FALSE>
// optional Parameter <Ident>  : ShowInMuPAD  <FALSE>
// optional Parameter <Ident>  : NoList       <TRUE>
// **************************************************************************
// Either returns a list containing all objects stored in the JVM (and/or)
// opens a JOption Pane showing all the objects stored in the JVM (and/or)
// shows all the objects stored in the JVM.
// **************************************************************************
// Return : A string describing the list of objects.
// **************************************************************************
java::callHO_getList := proc( )
local arguments, result, showInMuPAD, showInJava, returnList, i, leftOperator;
begin

  if (java::getStatus() = -1) then
    error ("Please reconnect the MuPAD notebook since the Java Virtual Machine was destroyed\nabnormally and has to be restarted.\n");
  end_if;

  result      := "";
  showInMuPAD := FALSE;
  showInJava  := FALSE;
  returnList  := TRUE;

  arguments := args();

  for i from 1 to nops(arguments) do
  	 //print ("Argument : " , arguments[i]);
    leftOperator := op(arguments, i);
    if leftOperator = hold(ShowInJava) then
      showInJava := TRUE;
    elif leftOperator = hold(ShowInMuPAD) then
      showInMuPAD := TRUE;
    elif leftOperator = hold(NoList) then
      returnList := FALSE; 
    else
      error("Wrong argument : " . expr2text(arguments[i]));
    end_if;
  end_for;

  if showInJava then
    result := java::module::callHO_getList(TRUE);
  else
    result := java::module::callHO_getList(FALSE);
  end_if;


  if showInMuPAD then
    if result = null() then
      print(Unquoted, "No list available.");
    end_if;
  	 for i from 1 to nops(result) do
  	 	 print(Unquoted, result[i]);
  	 end_for;
  end_if;

  if not returnList then
  	 null();
  else
    result;
  end_if;

end_proc:


