/*
________________________________________________________________________________

Inhalt....: Tests for arrays of the 'java'-package
Kategorie.: Package
Mathematik: Other
MuPAD.....: 2.5.0 / 3.0.0 / 3.1.1
Datum.....: 2003-08-04
Autoren...: Jrn Maas, <maas@mupad.de>
Funktionen: 
________________________________________________________________________________

The java-package


Multiple tests for many array functions (see sourcecode of Prog.java for details about each procedure).

 */
dllPath := pathname("%MUPAD_JRE_PATHjre", "bin", "client"):
package("java"):
java::start(DLLPath = dllPath);

/*
Tests with a single primitive returned and single array as parameter:
 */
java::Prog::returnBooleanFromSingleArrayBoolean([TRUE,FALSE], TRUE);
java::Prog::returnCharFromSingleArrayChar(["a","b"]);
java::Prog::returnByteFromSingleArrayByte([42,15]);
java::Prog::returnShortFromSingleArrayShort([42,8788]);
java::Prog::returnIntFromSingleArrayInt([1,42,15,8]);
java::Prog::returnLongFromSingleArrayLong([8788,1203]);
java::Prog::returnFloatFromSingleArrayFloat([42.88,12.3]);
java::Prog::returnDoubleFromSingleArrayDouble([12.3,42.88]);
java::Prog::returnBigIntegerFromSingleArrayBigInteger([42,15,8]);
java::Prog::returnBigDecimalFromSingleArrayBigDecimal([42.88,12.3,9.05]);
java::Prog::returnStringFromSingleArrayString(["MuPAD","Test for","Hello world"]);
/*
Tests with a single primitive returned and double array as parameter:
 */
java::Prog::returnBooleanFromDoubleArrayBoolean([[TRUE,FALSE,TRUE],[FALSE]]);
java::Prog::returnCharFromDoubleArrayChar([["a"],["b"]]);
java::Prog::returnByteFromDoubleArrayByte([[42],[15]]);
java::Prog::returnShortFromDoubleArrayShort([[42],[8788]]);
java::Prog::returnIntFromDoubleArrayInt([[1,42],[15,8]]);
java::Prog::returnLongFromDoubleArrayLong([[8788],[1203]]);
java::Prog::returnFloatFromDoubleArrayFloat([[42.88],[12.3]]);
java::Prog::returnDoubleFromDoubleArrayDouble([[12.3],[42.88]]);
java::Prog::returnBigIntegerFromDoubleArrayBigInteger([[42],[15,8]]);
java::Prog::returnBigDecimalFromDoubleArrayBigDecimal([[42.88,12.3],[9.05]]);
java::Prog::returnStringFromDoubleArrayString([["MuPAD","Test for"],["Hello world"]]);
/*
Tests with a single primitive returned and triple array as parameter:
 */
java::Prog::returnBooleanFromTripleArrayBoolean([[[TRUE,FALSE,TRUE],[FALSE]], [[TRUE,FALSE,TRUE],[FALSE]]]);
java::Prog::returnCharFromTripleArrayChar([[["a"],["b"]],[["a"],["b"]]]);
/*
What happens if the parameters are handed incorrectly ?
Korrekt:
 */
java::Prog::returnCharFromDoubleArrayChar([["a"],["b"], ["a"],["b"]]);
/*
Wrong:
 */
java::Prog::returnCharFromDoubleArrayChar([[["a"],["b"]],[["a"],["b"]]]);
/*
Test with a single array as return value
 */
java::Prog::returnSingleArrayInteger();
java::Prog::returnSingleArrayBoolean();
java::Prog::returnSingleArrayChar();
java::Prog::returnSingleArrayByte();
java::Prog::returnSingleArrayShort();
java::Prog::returnSingleArrayInt();
java::Prog::returnSingleArrayLong();
java::Prog::returnSingleArrayFloat();
java::Prog::returnSingleArrayDouble();
java::Prog::returnSingleArrayBigInteger();
java::Prog::returnSingleArrayBigDecimal();
java::Prog::returnSingleArrayString();
/*
Test with a double array as return value
 */
java::Prog::returnDoubleArrayInteger();
/*
Test with a triple array as return value
 */
java::Prog::returnTripleArrayInteger();
/*
Test with a quadruple array as return value
 */
java::Prog::returnQuadArrayInteger();
/*
Test with a quintuple array as return value
 */
java::Prog::returnQuintArrayInteger();
/*
Test with mixed parameters and return values
 */
java::Prog::returnSingleArrayBigInteger([1000000000,340982913810987203498034960989680958209871145870239870394260982709871109834509877640501987320903492044002398109834502870360928750918705981340986240984509872309410987340902394670439670987320981703980198327098309846092835019874576259087098712098098746087234730214102392034670437602398019870892604734908734098730478970732850529873240972309457230902398092834502985098275098274508972508934098723642645093203248053245723853250]);
/*
Callback test
 */
java::Prog::callbackTest();
/*
Test where arrays are called several times in a row...
 */
for i from 1 to 40000 do java::Prog::returnBooleanFromSingleArrayBoolean([TRUE,FALSE], FALSE) end_for;
/*
Test for objects in arrays
 */
HISTORY:=0;
frameArray := java::Prog::createJFrameArray(1000):
java::callHO_getList(ShowInJava);
java::callHO_clearList();
jframe1 := java::javax::swing::JFrame::JFrame("Test");
jframe2 := java::javax::swing::JFrame::JFrame("Test");
frameArray := [jframe1, jframe2];
test := java::Prog::isJFrameArray(frameArray);

