/*
________________________________________________________________________________

Inhalt....: An overall test suite for the most noteworthy functions in the package
Kategorie.: Package
Mathematik: Other
MuPAD.....: 2.5.0 / 3.0.0
Datum.....: 2003-09-25
Autoren...: Jrn Maas, <maas@mupad.de>
Funktionen: 
________________________________________________________________________________

The java-package

 */
package("java"):
cp := pathname("%MUPAD_JAVA_PATHclasses", "trisentis"):
java::start(ClassPath=cp)
;
/*
The matrix editor:
    In the doc directory of the java package a cvs file for testing can be found.
 */
a1 := [[1,2,3,4],[2,3,4,5],[4,5,7,8]];
java::matrixEditor(a1);
java::matrixEditor(3,4);
/*

The applet starter:
    Browsers retrieve the user directory automatically since they know the location. MuPAD
    can not know this.
 */
java::setWorkingDirectory("%MUPAD_JAVA_PATHclasses"):
/*
    Load the applet into applet1
 */
applet1 := java::trisentis::Trisentis::Trisentis():
/*
    Start it
 */
program := java::runApplet(applet1):
java::closeAppletFrame(program);
/*
MUCS (MuPAD Unit Construction System)
    First, reset the user directory!
 */
java::setWorkingDirectory("%MUPAD_JAVA_PATHclasses"):
/*
    We define a basic container
 */
mucs := java::mucs::mucs::mucs("A new MuPAD Unit Construction System"):
/*
    Now an input region (JTextField) with a predefined text
 */
textField := java::javax::swing::JTextField::JTextField("Textfield."):
/*
    Next we need a return button
 */
button := java::javax::swing::JButton::JButton("Press this button"):
/*
    Put the textfield into the north (0) of the predefined basic container
 */
java::mucs::addToContainer(textField, 0, UseObject=mucs):
/*
    Put the button into the south (1) of the predefined basic container
 */
java::mucs::addToContainer(button, 1, UseObject=mucs):
/*
    An object has to be defined which content is to be returned
 */
java::mucs::setReturnObject(textField, UseObject=mucs):
/*
    An object has to be defined that triggers the returning
 */
java::mucs::setTriggerObject(button, UseObject=mucs):
/*
    The user can define the size of the basic container
 */
java::mucs::setFrameSize(400,120, UseObject=mucs):
/*
    Not it is time to show what we put together
 */
java::mucs::showMucs(UseObject=mucs);
/*

Lister
 */
java::list("Prog", AccessSpecifier=Private, ShowInJava);


