/*
________________________________________________________________________________

Inhalt....: Test suite for the MatrixEditor
Kategorie.: Package
Mathematik: Other
MuPAD.....: 2.5.0 / 3.0.0 / 3.1.1
Datum.....: 2003-09-25
Autoren...: Jrn Maas, <maas@mupad.de>
Funktionen: 
________________________________________________________________________________

The java-package

 */
package("java"):
// java::debug(2);
/*
The modal alternative with a list:
 */
a1 := [[1,2,3],[2,3,4],[4,5,7]];
java::matrixEditor(a1);
java::console();
java::matrixEditor(a1, List);
java::matrixEditor(a1, Matrix);
java::matrixEditor(a1, List, Modal);
java::matrixEditor(a1, Matrix, Modal);
java::matrixEditor(a1, Modal);
/*
The modal alternative with a number
 */
java::matrixEditor(3);
java::matrixEditor(2, List);
java::matrixEditor(4, Matrix);
java::matrixEditor(5, List, Modal);
java::matrixEditor(3, Matrix, Modal);
java::matrixEditor(7, Modal);
/*
The modal alternative with a matrix
 */
a2 := [[1,2,3],[2,3,4],[4,5,7]];
mat := matrix(a2);
java::matrixEditor(mat);
java::matrixEditor(mat, List);
java::matrixEditor(mat, Matrix);
java::matrixEditor(mat, List, Modal);
java::matrixEditor(mat, Matrix, Modal);
java::matrixEditor(mat, Modal);
/*

The non modal version (String):
 */
a3 := [["1","2","3"],["2","3","4"],["4","5","7"]];
b3 := java::matrixEditor(3, NonModal);
c3 := java::getMatrix(b3, Integer, List);
java::showMatrix(b3);
java::getMatrix(b3, Integer);
java::getMatrix(b3, FloatingPoint);
java::getMatrix(b3, String, List);

java::console();
d3 := matrix(c3);
G := Graph::createGraphFromMatrix(d3);
Graph::printGraphInformation(G);
Graph::shortestPathAllPairs(G);

/*
The non modal version (BigDecimal and alternative call):
 */
a4 := [[1.0,2.0,3.0],[2.0,3.0,4.5],[4.5,5.6,7.7]];
b4 := java::matrixEditor(a4, NonModal);

/*

Some initial matrices for the MatrixEditor
 */

mat := matrix(50,50);
for i from 1 to 50 do
  for j from 1 to 50 do
    if (i<10) and (j>25) then
      dice := random(50..100);
      z := dice();
    elif (i<15) and (j<35) then
      dice := random(0..20);
      z := dice();
    elif (i>25) and (j>25) then
      dice := random(50..100);
      z := dice();
    elif (i>25) and (j<25) then
      dice := random(0..20);
      z := dice();
    else
      dice := random(100..120);
      z := dice();
    end_if;
    mat[i,j] := z;
  end_for;
end_for;
java::matrixEditor(mat);
for i from 1 to 50 do
  for j from 1 to 50 do
    if (i=j) or (i=j+1) then
      z := 100;
    elif (i+j=51) or (i+j=50) or (i+j=49) then
      z := 100;
    elif (i>44) and (j > 44) then
      z := 0;
    elif (i<5) and (j<5) then
      z := 0;
    else
      dice := random(0..100);
      z := dice();
    end_if;
    mat[i,j] := z;
  end_for;
end_for;

java::matrixEditor(mat);

