/*
_____________________________________________________________________________

Inhalt....: Tests for applet handling and output of the 'java'-package
Kategorie.: Package
Mathematik: Other
MuPAD.....: 2.5.0 / 3.0.0 / 3.1.1
Datum.....: 2003-09-20
Autoren...: Jrn Maas, <maas@mupad.de>
Funktionen: 
________________________________________________________________________________

The java-package


First, the package 'java' is loaded.
Afterwards a runtime test is done between a module function, a package procedure
and a java invocation.
This test was done to find out the overhead of an invocation.
Assumptions:
The function returnFourtyTwo exists in the Java module
The class TestSuite containing the static method return42 exists.
The procedure ret42 is defined: ret42 := proc() begin return(42); end_proc:

 */
package("java");
/* 
Switch off the history mechanism:
 */
HISTORY:=0:bytes():bytes()
;
/* 
Define a package procedure:
 */
ret42 := proc() begin return(42); end_proc: 
runs := 100000: 

a1:=rtime():a2:=time():
a1,a2;
for i from 1 to runs do
  java::module::returnFourtyTwo():
end_for;
b1:=rtime():b2:=time():
b1,b2;
(b2-a2)*msec;
(float((b2-a2)/1000))*sec;
print(Unquoted, "Per call: " . expr2text(float((b2-a2)/runs)). " msec");
bytes();
a1:=rtime():a2:=time():
a1,a2;
for i from 1 to runs do
  ret42():
end_for;
b1:=rtime():b2:=time():
b1,b2;
(b2-a2)*msec;
(float((b2-a2)/1000))*sec;
print(Unquoted, "Per call: " . expr2text(float((b2-a2)/runs)). " msec");
bytes();
/*
First start a JVM by hand, because otherwise the first start falsifies the result
 */
java::start();
a1:=rtime():a2:=time():
a1,a2;
for i from 1 to runs do
  java::TestSuite::return42():
end_for;
b1:=rtime():b2:=time():
b1,b2;
(b2-a2)*msec;
(float((b2-a2)/1000))*sec;
print(Unquoted, "Per call: " . expr2text(float((b2-a2)/runs)). " msec");
bytes();

