/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink.ui;

public class SyntaxTokenizer {
    public static final int NORMAL = 0;
    public static final int STRING = 1;
    public static final int COMMENT = 2;
    public static final int SYMBOL = 3;
    private static final int UNKNOWN = 4;
    private String text;
    private int state = 4;
    private int commentLevel = 0;
    private int tokenStart = 0;
    private int charIndex = -1;
    private int len = 0;

    public void setText(String string) {
        this.text = string;
        this.reset();
    }

    public void reset() {
        this.len = this.text.length();
        this.commentLevel = 0;
        this.tokenStart = 0;
        this.state = 4;
        this.charIndex = -1;
    }

    public SyntaxRecord getNextRecord() {
        Object var1_1 = null;
        block7: while (++this.charIndex < this.len) {
            char c = this.text.charAt(this.charIndex);
            switch (this.getState()) {
                case 2: {
                    if (c == ')' && this.text.charAt(this.charIndex - 1) == '*' && this.text.charAt(this.charIndex - 2) != '(') {
                        this.decrementComment();
                        if (this.getCommentLevel() != 0) break;
                        return this.switchState(2, 4);
                    }
                    if (c != '(' || this.charIndex >= this.len - 1 || this.text.charAt(this.charIndex + 1) != '*') continue block7;
                    this.setState(2);
                    break;
                }
                case 1: {
                    if (c != '\"') break;
                    int n = 0;
                    int n2 = this.charIndex - 1;
                    while (n2 >= 0 && this.text.charAt(n2) == '\\') {
                        ++n;
                        --n2;
                    }
                    if (n % 2 != 0) break;
                    return this.switchState(1, 4);
                }
                case 3: {
                    if (c == '\"') {
                        return this.switchState(3, 1);
                    }
                    if (c == '(' && this.charIndex < this.len - 1 && this.text.charAt(this.charIndex + 1) == '*') {
                        return this.switchState(3, 2);
                    }
                    if (SyntaxTokenizer.isSymbolChar(c)) break;
                    return this.switchState(3, 0);
                }
                case 0: {
                    if (c == '\"') {
                        return this.switchState(0, 1);
                    }
                    if (c == '(' && this.charIndex < this.len - 1 && this.text.charAt(this.charIndex + 1) == '*') {
                        return this.switchState(0, 2);
                    }
                    if (!SyntaxTokenizer.isSymbolStart(c)) break;
                    return this.switchState(0, 3);
                }
                case 4: {
                    if (c == '\"') {
                        this.setState(1);
                        break;
                    }
                    if (c == '(' && this.charIndex < this.len - 1 && this.text.charAt(this.charIndex + 1) == '*') {
                        this.setState(2);
                        break;
                    }
                    if (SyntaxTokenizer.isSymbolStart(c)) {
                        this.setState(3);
                        break;
                    }
                    this.setState(0);
                }
            }
        }
        if (this.getState() == 3) {
            return this.switchState(3, 4);
        }
        if (this.getState() != 4) {
            return this.switchState(0, 4);
        }
        this.setState(4);
        return null;
    }

    public boolean hasMoreRecords() {
        return this.charIndex < this.len - 1 || this.charIndex == this.len - 1 && this.getState() != 4;
    }

    private SyntaxRecord switchState(int n, int n2) {
        int n3 = n == 2 || n == 1 ? this.charIndex - this.tokenStart + 1 : this.charIndex - this.tokenStart;
        SyntaxRecord syntaxRecord = new SyntaxRecord(n, this.tokenStart, n3);
        this.setState(n2);
        return syntaxRecord;
    }

    private void setState(int n) {
        this.state = n;
        if (n == 2) {
            if (++this.commentLevel == 1) {
                this.tokenStart = this.charIndex;
            }
        } else {
            this.tokenStart = this.charIndex;
        }
    }

    private int getState() {
        return this.state;
    }

    private void decrementComment() {
        --this.commentLevel;
    }

    private int getCommentLevel() {
        return this.commentLevel;
    }

    private static boolean isSymbolStart(char c) {
        return Character.isLetter(c) || c == '$' || c == '`';
    }

    private static boolean isSymbolChar(char c) {
        return Character.isLetterOrDigit(c) || c == '$' || c == '`';
    }

    public class SyntaxRecord {
        public int type;
        public int start;
        public int length;

        SyntaxRecord(int n, int n2, int n3) {
            this.type = n;
            this.start = n2;
            this.length = n3;
        }
    }
}

