/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink.ui;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.ui.BracketMatcher;
import com.wolfram.jlink.ui.InterruptDialog;
import com.wolfram.jlink.ui.PktHandler;
import com.wolfram.jlink.ui.SyntaxTokenizer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.undo.UndoManager;

class MathSessionTextPane
extends JTextPane {
    private KernelLink ml;
    private String linkArgs;
    private String[] linkArgsArray;
    private int connectTimeout = 100000000;
    protected UndoManager undoManager = new UndoManager();
    private PropertyChangeSupport computationPropChangeSupport = new PropertyChangeSupport(this);
    private int leftIndent = 20;
    private int fontSize = 12;
    private Color textColor = Color.black;
    private Color promptColor = Color.blue;
    private Color messageColor = Color.red;
    private Color backgroundColor = Color.white;
    private boolean isInputBold = true;
    private boolean fitGraphics = false;
    private boolean feGraphics = false;
    private double lastTiming = 0.0;
    private Style base;
    private Style input;
    private Style output;
    private Style prompt;
    private Style print;
    private Style message;
    private Style graphics;
    private double charWidth;
    private int lineHeight = 10;
    private boolean useSyntaxColoring = true;
    private boolean colorsHaveChanged = false;
    private Color stringColor = new Color(20, 159, 175);
    private Color commentColor = new Color(94, 206, 11);
    private Color systemColor = new Color(132, 38, 187);
    private MutableAttributeSet attrNormal = new SimpleAttributeSet();
    private MutableAttributeSet attrString = new SimpleAttributeSet();
    private MutableAttributeSet attrSystem = new SimpleAttributeSet();
    private MutableAttributeSet attrComment = new SimpleAttributeSet();
    private HashMap systemSymbols = new HashMap();
    private Vector userSymbols;
    private Vector userColors;
    private boolean isInputMode;
    private BracketMatcher bracketMatcher = new BracketMatcher();
    private boolean wrap = false;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$Dialog;

    MathSessionTextPane() {
        this.setStyledDocument(new MTDocument());
        this.setEditable(false);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.base = this.addStyle("base", style);
        this.input = this.addStyle("input", this.base);
        this.output = this.addStyle("output", this.base);
        this.prompt = this.addStyle("prompt", this.base);
        this.message = this.addStyle("message", this.base);
        this.print = this.addStyle("print", this.base);
        this.graphics = this.addStyle("graphics", this.base);
        this.setBackgroundColor(this.backgroundColor);
        this.setTextSize(this.fontSize);
        this.setTextColor(this.textColor);
        this.setPromptColor(this.promptColor);
        this.setMessageColor(this.messageColor);
        this.setLeftIndent(this.leftIndent);
        this.setInputBoldface(this.isInputBold);
        this.setStringColor(this.stringColor);
        this.setSystemSymbolColor(this.systemColor);
        this.setCommentColor(this.commentColor);
        StyleConstants.setFontFamily(this.base, "Monospaced");
        int n = Utils.isMacOSX() || Utils.isClassicMacintosh() ? 4 : 2;
        int n2 = Utils.isMacOSX() || Utils.isClassicMacintosh() ? 4 : 8;
        Keymap keymap = JTextComponent.addKeymap(null, this.getKeymap());
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MathSessionTextPane.this.evaluateInput();
            }
        };
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MathSessionTextPane.this.undo();
            }
        };
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(90, n), abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MathSessionTextPane.this.redo();
            }
        };
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(89, n), abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MathSessionTextPane.this.balanceBrackets();
            }
        };
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(66, n), abstractAction4);
        AbstractAction abstractAction5 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MathSessionTextPane.this.copyInputFromAbove();
            }
        };
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(76, n), abstractAction5);
        AbstractAction abstractAction6 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MathSessionTextPane.this.abortEval();
            }
        };
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(46, n2), abstractAction6);
        AbstractAction abstractAction7 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MathSessionTextPane.this.interruptEval();
            }
        };
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(44, n2), abstractAction7);
        this.setKeymap(keymap);
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                if (MathSessionTextPane.this.isInputMode() && MathSessionTextPane.this.getDoc().isRecordUndos()) {
                    MathSessionTextPane.this.undoManager.addEdit(undoableEditEvent.getEdit());
                }
            }
        });
    }

    void setLink(KernelLink kernelLink) {
        this.ml = kernelLink;
    }

    KernelLink getLink() {
        return this.ml;
    }

    void setLinkArguments(String string) {
        this.linkArgs = string;
    }

    String getLinkArguments() {
        return this.linkArgs;
    }

    void setLinkArgumentsArray(String[] stringArray) {
        this.linkArgsArray = stringArray;
    }

    String[] getLinkArgumentsArray() {
        return this.linkArgsArray;
    }

    void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isComputationActive() {
        return this.ml != null && !this.isInputMode();
    }

    int getTextSize() {
        return this.fontSize;
    }

    void setTextSize(int n) {
        this.fontSize = n;
        StyleConstants.setFontSize(this.base, n);
    }

    Color getTextColor() {
        return this.textColor;
    }

    void setTextColor(Color color) {
        this.textColor = color;
        StyleConstants.setForeground(this.base, color);
        StyleConstants.setForeground(this.attrNormal, this.textColor);
        this.colorsHaveChanged = true;
        this.doSyntaxColor();
        this.repaint();
    }

    Color getStringColor() {
        return this.stringColor;
    }

    void setStringColor(Color color) {
        this.stringColor = color;
        StyleConstants.setForeground(this.attrString, this.stringColor);
        this.colorsHaveChanged = true;
        this.doSyntaxColor();
        this.repaint();
    }

    Color getCommentColor() {
        return this.commentColor;
    }

    void setCommentColor(Color color) {
        this.commentColor = color;
        StyleConstants.setForeground(this.attrComment, this.commentColor);
        this.colorsHaveChanged = true;
        this.doSyntaxColor();
        this.repaint();
    }

    Color getSystemSymbolColor() {
        return this.systemColor;
    }

    void setSystemSymbolColor(Color color) {
        this.systemColor = color;
        StyleConstants.setForeground(this.attrSystem, this.systemColor);
        this.colorsHaveChanged = true;
        this.doSyntaxColor();
        this.repaint();
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.setBackground(color);
        this.setCaretColor(new Color(this.backgroundColor.getRed() ^ 0xFF, this.backgroundColor.getGreen() ^ 0xFF, this.backgroundColor.getBlue() ^ 0xFF));
    }

    Color getPromptColor() {
        return this.promptColor;
    }

    void setPromptColor(Color color) {
        this.promptColor = color;
        StyleConstants.setForeground(this.prompt, color);
    }

    Color getMessageColor() {
        return this.messageColor;
    }

    void setMessageColor(Color color) {
        this.messageColor = color;
        StyleConstants.setForeground(this.message, color);
    }

    int getLeftIndent() {
        return this.leftIndent;
    }

    void setLeftIndent(int n) {
        this.leftIndent = n;
        StyleConstants.setLeftIndent(this.input, n);
        StyleConstants.setLeftIndent(this.output, n);
        StyleConstants.setLeftIndent(this.message, n);
        StyleConstants.setLeftIndent(this.print, n);
        StyleConstants.setLeftIndent(this.graphics, n);
    }

    boolean isInputBoldface() {
        return this.isInputBold;
    }

    void setInputBoldface(boolean bl) {
        this.isInputBold = bl;
        StyleConstants.setBold(this.input, bl);
    }

    void setFitGraphics(boolean bl) {
        this.fitGraphics = bl;
    }

    boolean isFitGraphics() {
        return this.fitGraphics;
    }

    void setFrontEndGraphics(boolean bl) {
        this.feGraphics = bl;
    }

    boolean isFrontEndGraphics() {
        return this.feGraphics;
    }

    double getLastTiming() {
        return this.lastTiming;
    }

    boolean isSyntaxColoring() {
        return this.useSyntaxColoring;
    }

    void setSyntaxColoring(boolean bl) {
        this.useSyntaxColoring = bl;
        this.colorsHaveChanged = true;
        this.doSyntaxColor();
        this.repaint();
    }

    private void setSystemSymbols(String[] stringArray) {
        this.systemSymbols.clear();
        int n = 0;
        while (n < stringArray.length) {
            this.systemSymbols.put(stringArray[n], stringArray[n]);
            ++n;
        }
    }

    void addColoredSymbols(String[] stringArray, Color color) {
        if (this.userSymbols == null) {
            this.userSymbols = new Vector(1);
        }
        if (this.userColors == null) {
            this.userColors = new Vector(1);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            hashMap.put(stringArray[n], stringArray[n]);
            ++n;
        }
        this.userSymbols.addElement(hashMap);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, color);
        this.userColors.addElement(simpleAttributeSet);
        this.colorsHaveChanged = true;
        this.doSyntaxColor();
        this.repaint();
    }

    void clearColoredSymbols() {
        this.userSymbols = null;
        this.userColors = null;
        this.colorsHaveChanged = true;
        this.doSyntaxColor();
        this.repaint();
    }

    void doSyntaxColor() {
        this.getDoc().doSyntaxColor();
    }

    void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    boolean canRedo() {
        return this.undoManager.canRedo();
    }

    boolean canUndo() {
        return this.undoManager.canUndo();
    }

    private void setInputMode(boolean bl) {
        boolean bl2 = this.isInputMode;
        this.isInputMode = bl;
        if (bl2 != bl) {
            this.computationPropChangeSupport.firePropertyChange("computationActive", new Boolean(!bl2), new Boolean(!bl));
        }
    }

    private boolean isInputMode() {
        return this.isInputMode;
    }

    public void addComputationPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.computationPropChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeComputationPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.computationPropChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    void connect() throws MathLinkException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setInputMode(false);
        try {
            if (this.ml == null) {
                if (this.linkArgs != null) {
                    this.ml = MathLinkFactory.createKernelLink(this.linkArgs);
                } else if (this.linkArgsArray != null) {
                    this.ml = MathLinkFactory.createKernelLink(this.linkArgsArray);
                }
            }
            this.ml.connect(this.connectTimeout);
        }
        catch (MathLinkException mathLinkException) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            throw mathLinkException;
        }
        boolean bl = this.ml.equals(StdLink.getLink());
        if (bl) {
            StdLink.requestTransaction();
        }
        this.ml.evaluate("$Line");
        while (this.ml.waitForAnswer() != 3) {
            this.ml.newPacket();
        }
        final String string = "In[" + Integer.toString(this.ml.getInteger()) + "]:=\n";
        this.ml.newPacket();
        if (bl) {
            StdLink.requestTransaction();
        }
        this.ml.evaluate("Needs[\"JLink`\"]");
        this.ml.discardAnswer();
        if (bl) {
            StdLink.requestTransaction();
        }
        this.ml.evaluate("Names[\"System`*\"]");
        this.ml.waitForAnswer();
        String[] stringArray = this.ml.getStringArray1();
        this.setSystemSymbols(stringArray);
        this.ml.addPacketListener(new PktHandler(this, this.getDoc()));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = MathSessionTextPane.class$("java.awt.Frame")) : class$java$awt$Frame, this);
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = MathSessionTextPane.class$("java.awt.Dialog")) : class$java$awt$Dialog, this);
        if (frame != null) {
            this.ml.addPacketListener(new InterruptDialog(frame));
        } else if (dialog != null) {
            this.ml.addPacketListener(new InterruptDialog(dialog));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MTDocument mTDocument = MathSessionTextPane.this.getDoc();
                mTDocument.setLogicalStyle(mTDocument.getLength(), MathSessionTextPane.this.getStyle("prompt"));
                try {
                    mTDocument.insertString(mTDocument.getLength(), string, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                try {
                    MathSessionTextPane.this.charWidth = (MathSessionTextPane.this.modelToView(7).getX() - MathSessionTextPane.this.modelToView(0).getX()) / 7.0;
                    MathSessionTextPane.this.lineHeight = (int)(MathSessionTextPane.this.modelToView(MathSessionTextPane.this.getDoc().getLength()).getY() - MathSessionTextPane.this.modelToView(0).getY());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                mTDocument.setFirstEditPos(mTDocument.getLength());
                mTDocument.setLogicalStyle(mTDocument.getLength(), MathSessionTextPane.this.getStyle("input"));
                MathSessionTextPane.this.setInputMode(true);
                MathSessionTextPane.this.setEditable(true);
                MathSessionTextPane.this.setCursor(Cursor.getPredefinedCursor(2));
                MathSessionTextPane.this.getCaret().setVisible(true);
            }
        });
    }

    void closeLink() {
        if (this.ml != null) {
            this.ml.close();
            this.ml = null;
        }
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.lineHeight;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.wrap) {
            Container container = this.getParent();
            TextUI textUI = this.getUI();
            int n = textUI.getPreferredSize((JComponent)this).width;
            int n2 = container.getSize().width;
            return container != null ? textUI.getPreferredSize((JComponent)this).width < container.getSize().width : true;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.wrap) {
            super.setBounds(n, n2, n3, n4);
        } else {
            Dimension dimension = this.getPreferredSize();
            super.setBounds(n, n2, Math.max(dimension.width, n3), Math.max(dimension.height, n4));
        }
    }

    Dimension getVisibleTextBounds() {
        JViewport jViewport = (JViewport)this.getParent();
        Point point = jViewport.getViewPosition();
        Point point2 = new Point(point.x + jViewport.getSize().width, point.y + jViewport.getSize().height);
        return new Dimension(this.viewToModel(point), this.viewToModel(point2));
    }

    private MTDocument getDoc() {
        return (MTDocument)this.getDocument();
    }

    void evaluateInput() {
        if (!this.isInputMode() || this.ml == null) {
            return;
        }
        int n = this.getDoc().getFirstEditPos();
        if (this.getSelectionStart() >= n && this.getSelectionEnd() >= n) {
            try {
                this.getDoc().insertString(this.getDoc().getLength(), "\n\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.undoManager.discardAllEdits();
            EvalTask evalTask = new EvalTask();
            new Thread(evalTask).start();
        } else {
            this.getToolkit().beep();
        }
    }

    private void abortEval() {
        if (!this.isInputMode()) {
            try {
                this.ml.putMessage(3);
            }
            catch (MathLinkException mathLinkException) {
                mathLinkException.printStackTrace();
            }
        }
    }

    private void interruptEval() {
        if (!this.isInputMode()) {
            try {
                this.ml.putMessage(2);
            }
            catch (MathLinkException mathLinkException) {
                mathLinkException.printStackTrace();
            }
        }
    }

    void balanceBrackets() {
        this.bracketMatcher.setText(this.getDoc().getEvalInput());
        int n = this.getDoc().getFirstEditPos();
        Point point = null;
        if (this.getSelectionStart() >= n) {
            point = this.bracketMatcher.balance(this.getSelectionStart() - n, this.getSelectionEnd() - this.getSelectionStart());
        }
        if (point != null) {
            this.setSelectionStart(n + point.x);
            this.setSelectionEnd(n + point.y);
        } else {
            this.getToolkit().beep();
        }
    }

    void copyInputFromAbove() {
        if (this.isInputMode()) {
            MTDocument mTDocument = this.getDoc();
            int n = mTDocument.getFirstEditPos();
            if (this.getSelectionStart() >= n && this.getSelectionEnd() >= n) {
                int n2 = 0;
                int n3 = 0;
                Style style = this.getStyle("input");
                int n4 = n - 1;
                while (n4 >= 0) {
                    if (mTDocument.getLogicalStyle(n4).equals(style)) {
                        if (n3 == 0) {
                            n3 = n4 + 1;
                        }
                    } else if (n3 != 0) {
                        n2 = n4 + 1;
                        break;
                    }
                    --n4;
                }
                if (n2 != 0 && n3 != 0) {
                    try {
                        String string = this.getText(n2, n3 - n2);
                        if (string.endsWith("\n\n")) {
                            string = string.substring(0, string.length() - 2);
                        }
                        this.replaceSelection(string);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            } else {
                this.getToolkit().beep();
            }
        }
    }

    private static boolean intervalsIntersect(int n, int n2, int n3, int n4) {
        return n <= n4 && n2 >= n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MTDocument
    extends DefaultStyledDocument {
        private int firstEditPos;
        private SyntaxTokenizer tokenizer = new SyntaxTokenizer();
        private int lastStyledStart = Integer.MAX_VALUE;
        private int lastStyledEnd = Integer.MIN_VALUE;
        protected boolean recordUndos = true;
        private boolean lastPassWasColored = false;

        MTDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (n < this.firstEditPos) {
                MathSessionTextPane.this.getToolkit().beep();
            } else {
                super.insertString(n, string, attributeSet);
                this.lastStyledStart = Integer.MAX_VALUE;
                this.lastStyledEnd = Integer.MIN_VALUE;
                this.doSyntaxColor();
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (n < this.firstEditPos) {
                MathSessionTextPane.this.getToolkit().beep();
            } else {
                super.remove(n, n2);
                this.lastStyledStart = Integer.MAX_VALUE;
                this.lastStyledEnd = Integer.MIN_VALUE;
                this.doSyntaxColor();
            }
        }

        public boolean isRecordUndos() {
            return this.recordUndos;
        }

        void setFirstEditPos(int n) {
            this.firstEditPos = n;
        }

        int getFirstEditPos() {
            return this.firstEditPos;
        }

        String getEvalInput() {
            try {
                return this.getText(this.firstEditPos, this.getLength() - this.firstEditPos);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doSyntaxColor() {
            if (!MathSessionTextPane.this.isInputMode()) {
                return;
            }
            if (!MathSessionTextPane.this.isSyntaxColoring() && !MathSessionTextPane.this.colorsHaveChanged) {
                return;
            }
            if (!MathSessionTextPane.this.isSyntaxColoring()) {
                this.recordUndos = false;
                try {
                    this.setCharacterAttributes(this.firstEditPos, this.getLength() - this.firstEditPos, MathSessionTextPane.this.attrNormal, false);
                    Object var2_1 = null;
                    this.recordUndos = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.recordUndos = false;
                    MathSessionTextPane.this.colorsHaveChanged = false;
                    throw throwable;
                }
                MathSessionTextPane.this.colorsHaveChanged = false;
                return;
            }
            Dimension dimension = MathSessionTextPane.this.getVisibleTextBounds();
            int n = Math.max(dimension.width - this.firstEditPos, 0);
            int n2 = dimension.height - this.firstEditPos;
            if (n2 < 0) {
                return;
            }
            int n3 = n;
            int n4 = n2;
            if (MathSessionTextPane.this.colorsHaveChanged) {
                n3 = 0;
                n4 = this.getLength() - this.firstEditPos;
            } else {
                if (n >= this.lastStyledStart && n2 <= this.lastStyledEnd) {
                    return;
                }
                if (n < this.lastStyledStart) {
                    n4 = n2 > this.lastStyledEnd ? n2 : this.lastStyledStart;
                } else if (n2 > this.lastStyledEnd) {
                    n3 = n < this.lastStyledStart ? n : this.lastStyledEnd;
                }
            }
            MathSessionTextPane.this.colorsHaveChanged = false;
            String string = this.getEvalInput();
            this.tokenizer.setText(string);
            this.recordUndos = false;
            try {
                this.setCharacterAttributes(this.firstEditPos + n3, n4 - n3, MathSessionTextPane.this.attrNormal, false);
                MutableAttributeSet mutableAttributeSet = MathSessionTextPane.this.attrNormal;
                AttributeSet attributeSet = null;
                while (this.tokenizer.hasMoreRecords()) {
                    SyntaxTokenizer.SyntaxRecord syntaxRecord = this.tokenizer.getNextRecord();
                    switch (syntaxRecord.type) {
                        case 0: {
                            attributeSet = MathSessionTextPane.this.attrNormal;
                            break;
                        }
                        case 2: {
                            attributeSet = MathSessionTextPane.this.attrComment;
                            break;
                        }
                        case 1: {
                            attributeSet = MathSessionTextPane.this.attrString;
                            break;
                        }
                        case 3: {
                            attributeSet = MathSessionTextPane.this.attrNormal;
                            String string2 = string.substring(syntaxRecord.start, syntaxRecord.start + syntaxRecord.length);
                            boolean bl = false;
                            if (MathSessionTextPane.this.userSymbols != null) {
                                int n5 = MathSessionTextPane.this.userSymbols.size();
                                int n6 = 0;
                                while (n6 < n5) {
                                    HashMap hashMap = (HashMap)MathSessionTextPane.this.userSymbols.elementAt(n6);
                                    if (hashMap.containsKey(string2)) {
                                        bl = true;
                                        attributeSet = (AttributeSet)MathSessionTextPane.this.userColors.elementAt(n6);
                                    }
                                    ++n6;
                                }
                            }
                            if (bl || !MathSessionTextPane.this.systemSymbols.containsKey(string2)) break;
                            attributeSet = MathSessionTextPane.this.attrSystem;
                        }
                    }
                    if (attributeSet != MathSessionTextPane.this.attrNormal && attributeSet != mutableAttributeSet && MathSessionTextPane.intervalsIntersect(syntaxRecord.start, syntaxRecord.start + syntaxRecord.length, n3, n4)) {
                        this.setCharacterAttributes(syntaxRecord.start + this.firstEditPos, syntaxRecord.length, attributeSet, false);
                    }
                    mutableAttributeSet = attributeSet;
                }
                Object var16_18 = null;
                this.recordUndos = true;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                this.recordUndos = true;
                throw throwable;
            }
            this.lastStyledStart = Math.min(this.lastStyledStart, Math.min(n3, n));
            this.lastStyledEnd = Math.max(this.lastStyledEnd, Math.max(n4, n2));
        }
    }

    class EvalTask
    implements Runnable {
        EvalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l;
            block21: {
                if (Utils.isMacOSX()) {
                    try {
                        Thread.sleep(60L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                MathSessionTextPane.this.setEditable(false);
                MathSessionTextPane.this.setInputMode(false);
                MathSessionTextPane.this.setCursor(Cursor.getPredefinedCursor(3));
                l = System.currentTimeMillis();
                try {
                    if (MathSessionTextPane.this.ml.equals(StdLink.getLink())) {
                        StdLink.requestTransaction();
                        KernelLink kernelLink = MathSessionTextPane.this.ml;
                        synchronized (kernelLink) {
                            this.preEval();
                        }
                        StdLink.requestTransaction();
                        KernelLink kernelLink2 = MathSessionTextPane.this.ml;
                        synchronized (kernelLink2) {
                            MathSessionTextPane.this.ml.putFunction("EnterTextPacket", 1);
                            MathSessionTextPane.this.ml.put(MathSessionTextPane.this.getDoc().getEvalInput());
                            MathSessionTextPane.this.ml.discardAnswer();
                        }
                        StdLink.requestTransaction();
                        KernelLink kernelLink3 = MathSessionTextPane.this.ml;
                        synchronized (kernelLink3) {
                            this.postEval();
                            break block21;
                        }
                    }
                    KernelLink kernelLink = MathSessionTextPane.this.ml;
                    synchronized (kernelLink) {
                        this.preEval();
                        MathSessionTextPane.this.ml.putFunction("EnterTextPacket", 1);
                        MathSessionTextPane.this.ml.put(MathSessionTextPane.this.getDoc().getEvalInput());
                        MathSessionTextPane.this.ml.discardAnswer();
                        this.postEval();
                    }
                }
                catch (MathLinkException mathLinkException) {
                    if (!MathSessionTextPane.this.ml.clearError() || mathLinkException.getErrCode() == 11) {
                        MathSessionTextPane.this.closeLink();
                    }
                    MathSessionTextPane.this.ml.newPacket();
                }
            }
            MathSessionTextPane.this.lastTiming = (double)(System.currentTimeMillis() - l) / 1000.0;
            MathSessionTextPane.this.setCaretPosition(MathSessionTextPane.this.getDoc().getLength());
            MathSessionTextPane.this.getCaret().setVisible(true);
            MathSessionTextPane.this.undoManager.discardAllEdits();
            if (MathSessionTextPane.this.getLink() != null) {
                MathSessionTextPane.this.setInputMode(true);
                MathSessionTextPane.this.setEditable(true);
                MathSessionTextPane.this.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                MathSessionTextPane.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        private void preEval() throws MathLinkException {
            int n = (int)((double)(MathSessionTextPane.this.getParent().getSize().width - MathSessionTextPane.this.getLeftIndent()) / MathSessionTextPane.this.charWidth);
            String string = "(LinkWrite[$ParentLink, DisplayPacket[EvaluateToImage[#, " + (MathSessionTextPane.this.feGraphics ? "True" : "False") + (MathSessionTextPane.this.fitGraphics ? ", ImageSize->{" + (MathSessionTextPane.this.getParent().getSize().width - MathSessionTextPane.this.getLeftIndent() - 10) + ", Automatic}" : "") + "]]]; #)&";
            MathSessionTextPane.this.ml.evaluate("{JLink`Private`cfv, JLink`Private`sopts, JLink`Private`ddf} = {FormatValues[Continuation], Options[\"stdout\"], $DisplayFunction} ; Format[Continuation[_], OutputForm] = \"\" ; SetOptions[\"stdout\", CharacterEncoding -> \"Unicode\", PageWidth -> " + n + "] ; " + "$DisplayFunction = " + string + ";");
            MathSessionTextPane.this.ml.discardAnswer();
        }

        private void postEval() throws MathLinkException {
            MathSessionTextPane.this.ml.evaluate("FormatValues[Continuation] = JLink`Private`cfv ; SetOptions[\"stdout\", JLink`Private`sopts] ; $DisplayFunction = JLink`Private`ddf ;");
            MathSessionTextPane.this.ml.discardAnswer();
        }
    }
}

