/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink.ui;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.ui.MathSessionTextPane;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.RepaintManager;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MathSessionPane
extends JScrollPane {
    private MathSessionTextPane textPane;
    private boolean showTiming = true;
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

    public MathSessionPane() {
        this(22, 32);
    }

    public MathSessionPane(int n, int n2) {
        this.textPane = new MathSessionTextPane();
        this.textPane.addComputationPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MathSessionPane.this.propChangeSupport.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
        ScrollPaneLayout scrollPaneLayout = new ScrollPaneLayout(){

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                JScrollBar jScrollBar = this.getHorizontalScrollBar();
                if (jScrollBar != null) {
                    Rectangle rectangle = jScrollBar.getBounds();
                    int n = MathSessionPane.this.isShowTiming() ? 100 : 0;
                    jScrollBar.setBounds(rectangle.x + n, rectangle.y, rectangle.width - n, rectangle.height);
                    this.lowerLeft.setBounds(0, rectangle.y, n, rectangle.height);
                    if (Utils.isMacOSX() && MathSessionPane.this.isShowTiming()) {
                        RepaintManager.currentManager(MathSessionPane.this).markCompletelyClean(MathSessionPane.this);
                    }
                }
                jScrollBar.validate();
            }
        };
        this.setLayout(scrollPaneLayout);
        scrollPaneLayout.syncWithScrollPane(this);
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
        this.setViewportView(this.textPane);
        this.setDoubleBuffered(true);
        final JPanel jPanel = new JPanel(){

            public void paintComponent(Graphics graphics) {
                String string = Double.toString(MathSessionPane.this.textPane.getLastTiming()) + " seconds";
                graphics.setColor(MathSessionPane.this.getHorizontalScrollBar().getBackground());
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                graphics.setColor(Color.black);
                graphics.drawString(string, 6, this.getHeight() - 2);
            }
        };
        this.setCorner("LOWER_LEFT_CORNER", jPanel);
        this.textPane.addComputationPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    jPanel.repaint();
                }
            }
        });
        this.getViewport().addChangeListener(new ChangeListener(){
            private Dimension lastVisibleBounds = new Dimension(0, 0);

            public void stateChanged(ChangeEvent changeEvent) {
                Dimension dimension = MathSessionPane.this.textPane.getVisibleTextBounds();
                if (!dimension.equals(this.lastVisibleBounds)) {
                    MathSessionPane.this.textPane.doSyntaxColor();
                    this.lastVisibleBounds = dimension;
                }
            }
        });
    }

    public void setLink(KernelLink kernelLink) {
        this.textPane.setLink(kernelLink);
    }

    public KernelLink getLink() {
        return this.textPane.getLink();
    }

    public void setLinkArguments(String string) {
        this.textPane.setLinkArguments(string);
    }

    public void setLinkArgumentsArray(String[] stringArray) {
        this.textPane.setLinkArgumentsArray(stringArray);
    }

    public String getLinkArguments() {
        return this.textPane.getLinkArguments();
    }

    public String[] getLinkArgumentsArray() {
        return this.textPane.getLinkArgumentsArray();
    }

    public void setConnectTimeout(int n) {
        this.textPane.setConnectTimeout(n);
    }

    public int getConnectTimeout() {
        return this.textPane.getConnectTimeout();
    }

    public String getText() {
        return this.textPane.getText();
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public boolean isComputationActive() {
        return this.textPane.isComputationActive();
    }

    public int getTextSize() {
        return this.textPane.getTextSize();
    }

    public void setTextSize(int n) {
        this.textPane.setTextSize(n);
    }

    public boolean isSyntaxColoring() {
        return this.textPane.isSyntaxColoring();
    }

    public void setSyntaxColoring(boolean bl) {
        this.textPane.setSyntaxColoring(bl);
    }

    public Color getTextColor() {
        return this.textPane.getTextColor();
    }

    public void setTextColor(Color color) {
        this.textPane.setTextColor(color);
    }

    public Color getStringColor() {
        return this.textPane.getStringColor();
    }

    public void setStringColor(Color color) {
        this.textPane.setStringColor(color);
    }

    public Color getCommentColor() {
        return this.textPane.getCommentColor();
    }

    public void setCommentColor(Color color) {
        this.textPane.setCommentColor(color);
    }

    public Color getSystemSymbolColor() {
        return this.textPane.getSystemSymbolColor();
    }

    public void setSystemSymbolColor(Color color) {
        this.textPane.setSystemSymbolColor(color);
    }

    public Color getBackgroundColor() {
        return this.textPane.getBackgroundColor();
    }

    public void setBackgroundColor(Color color) {
        this.textPane.setBackgroundColor(color);
    }

    public Color getPromptColor() {
        return this.textPane.getPromptColor();
    }

    public void setPromptColor(Color color) {
        this.textPane.setPromptColor(color);
    }

    public Color getMessageColor() {
        return this.textPane.getMessageColor();
    }

    public void setMessageColor(Color color) {
        this.textPane.setMessageColor(color);
    }

    public int getLeftIndent() {
        return this.textPane.getLeftIndent();
    }

    public void setLeftIndent(int n) {
        this.textPane.setLeftIndent(n);
    }

    public boolean isInputBoldface() {
        return this.textPane.isInputBoldface();
    }

    public void setInputBoldface(boolean bl) {
        this.textPane.setInputBoldface(bl);
    }

    public void setFitGraphics(boolean bl) {
        this.textPane.setFitGraphics(bl);
    }

    public boolean isFitGraphics() {
        return this.textPane.isFitGraphics();
    }

    public void setFrontEndGraphics(boolean bl) {
        this.textPane.setFrontEndGraphics(bl);
    }

    public boolean isFrontEndGraphics() {
        return this.textPane.isFrontEndGraphics();
    }

    public void addColoredSymbols(String[] stringArray, Color color) {
        this.textPane.addColoredSymbols(stringArray, color);
    }

    public void clearColoredSymbols() {
        this.textPane.clearColoredSymbols();
    }

    public void setShowTiming(boolean bl) {
        this.showTiming = bl;
        this.doLayout();
    }

    public boolean isShowTiming() {
        return this.showTiming;
    }

    public void evaluateInput() {
        this.textPane.evaluateInput();
    }

    public void undo() {
        this.textPane.undo();
    }

    public void redo() {
        this.textPane.redo();
    }

    public boolean canRedo() {
        return this.textPane.canRedo();
    }

    public boolean canUndo() {
        return this.textPane.canUndo();
    }

    public void copyInputFromAbove() {
        this.textPane.copyInputFromAbove();
    }

    public void balanceBrackets() {
        this.textPane.balanceBrackets();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.textPane != null) {
            this.textPane.addComputationPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.textPane != null) {
            this.textPane.removeComputationPropertyChangeListener(propertyChangeListener);
        }
    }

    public void connect() throws MathLinkException {
        this.textPane.connect();
    }

    public void closeLink() {
        this.textPane.closeLink();
    }
}

