/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink.ui;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.PacketArrivedEvent;
import com.wolfram.jlink.PacketListener;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class InterruptDialog
extends JDialog
implements ActionListener,
PacketListener {
    private String response;
    private JButton b1;
    private JButton b2;
    private JButton b3;
    private JButton b4;
    private JButton b5;
    private JButton b6;
    private JButton b7;
    Frame parentFrame;
    Dialog parentDialog;

    public InterruptDialog(Frame frame) {
        super(frame, true);
        this.parentFrame = frame;
        this.setup();
    }

    public InterruptDialog(Dialog dialog) {
        super(dialog, true);
        this.parentDialog = dialog;
        this.setup();
    }

    private void setup() {
        this.setTitle("Interrupt");
        this.setResizable(false);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        container.add(jPanel);
        jPanel.setLayout(new GridLayout(9, 1, 6, 6));
        this.b1 = new JButton("Abort Command Being Evaluated");
        this.b2 = new JButton("Enter Inspector Dialog");
        this.b3 = new JButton("Send Interrupt to Linked Program");
        this.b4 = new JButton("Send Abort to Linked Program");
        this.b5 = new JButton("Kill Linked Program");
        this.b6 = new JButton("Continue Evaluation");
        this.b7 = new JButton("Quit the Mathematica Kernel");
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        jPanel.add(this.b1);
        jPanel.add(this.b2);
        jPanel.add(panel);
        jPanel.add(this.b3);
        jPanel.add(this.b4);
        jPanel.add(this.b5);
        jPanel.add(panel2);
        jPanel.add(this.b6);
        jPanel.add(this.b7);
        this.b1.addActionListener(this);
        this.b2.addActionListener(this);
        this.b3.addActionListener(this);
        this.b4.addActionListener(this);
        this.b5.addActionListener(this);
        this.b6.addActionListener(this);
        this.b7.addActionListener(this);
        this.pack();
        this.doLayout();
        Rectangle rectangle = jPanel.getBounds();
        container.setLayout(null);
        jPanel.setBounds(rectangle.x + 10, rectangle.y + 5, rectangle.width, rectangle.height);
        this.setSize(this.getSize().width + 20, this.getSize().height + 10);
    }

    public boolean packetArrived(PacketArrivedEvent packetArrivedEvent) throws MathLinkException {
        boolean bl = true;
        KernelLink kernelLink = (KernelLink)packetArrivedEvent.getSource();
        if (packetArrivedEvent.getPktType() == 6) {
            int n = kernelLink.getInteger();
            String string = kernelLink.getString();
            this.doDialog(n);
            kernelLink.put(this.response != null ? this.response : "c");
            kernelLink.flush();
            this.response = null;
            bl = false;
        }
        return bl;
    }

    private void doDialog(int n) {
        switch (n) {
            case 1: {
                this.b1.setEnabled(true);
                this.b2.setEnabled(true);
                this.b3.setEnabled(false);
                this.b4.setEnabled(false);
                this.b5.setEnabled(false);
                break;
            }
            case 3: {
                this.b1.setEnabled(false);
                this.b2.setEnabled(false);
                this.b3.setEnabled(true);
                this.b4.setEnabled(true);
                this.b5.setEnabled(true);
                break;
            }
            default: {
                return;
            }
        }
        if (this.parentFrame != null) {
            this.setLocationRelativeTo(this.parentFrame);
        } else {
            this.setLocationRelativeTo(this.parentDialog);
        }
        this.doLayout();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.b1) {
            this.response = "a";
        } else if (object == this.b2) {
            this.response = "i";
        } else if (object == this.b3) {
            this.response = "r";
        } else if (object == this.b4) {
            this.response = "a";
        } else if (object == this.b5) {
            this.response = "k";
        } else if (object == this.b6) {
            this.response = "c";
        } else if (object == this.b7) {
            this.response = "exit";
        }
        this.dispose();
    }
}

