/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink.ui;

import com.wolfram.jlink.MathFrame;
import com.wolfram.jlink.ui.TextAreaOutputStream;
import java.awt.Button;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.PrintStream;

public class ConsoleWindow
extends MathFrame {
    public static final int NONE = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    private static ConsoleWindow theConsoleWindow;
    private static int maxLines;
    private static boolean isFirstTime;
    private static PrintStream strm;
    private static PrintStream oldOut;
    private static PrintStream oldErr;

    public static synchronized ConsoleWindow getInstance() {
        if (theConsoleWindow == null) {
            theConsoleWindow = new ConsoleWindow();
        }
        return theConsoleWindow;
    }

    public static synchronized void setMaxLines(int n) {
        maxLines = n;
    }

    public static synchronized void setCapture(int n) {
        if ((n & 1) != 0) {
            System.setOut(strm);
        } else {
            System.setOut(oldOut);
        }
        if ((n & 2) != 0) {
            System.setErr(strm);
        } else {
            System.setErr(oldErr);
        }
    }

    public static boolean isFirstTime() {
        return isFirstTime;
    }

    public static void setFirstTime(boolean bl) {
        isFirstTime = bl;
    }

    private ConsoleWindow() {
        Object object;
        Object object2;
        oldOut = System.out;
        oldErr = System.err;
        this.setTitle("J/Link Java Console");
        this.setBackground(SystemColor.control);
        this.setResizable(true);
        Button button = new Button("Clear");
        Button button2 = new Button("Close");
        TextArea textArea = new TextArea();
        final TextAreaOutputStream textAreaOutputStream = new TextAreaOutputStream(textArea, maxLines);
        strm = new PrintStream(textAreaOutputStream, true);
        strm.println("J/Link version 2.1.0");
        try {
            object2 = System.getProperty("java.version");
            object = System.getProperty("java.vm.name");
            strm.println("Java version " + (String)object2 + "  " + (String)(object != null ? object : ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        strm.println("-------------------------");
        textArea.setEditable(false);
        textArea.setFont(new Font("Monospaced", 0, 12));
        object2 = new GridBagLayout();
        object = new GridBagConstraints();
        this.setLayout((LayoutManager)object2);
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.95;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagLayout)object2).setConstraints(textArea, (GridBagConstraints)object);
        this.add(textArea);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(4, 20, 2, 20);
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).weighty = 0.05;
        ((GridBagLayout)object2).setConstraints(button, (GridBagConstraints)object);
        this.add(button);
        ((GridBagLayout)object2).setConstraints(button2, (GridBagConstraints)object);
        this.add(button2);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (textAreaOutputStream != null) {
                    textAreaOutputStream.reset();
                }
            }
        });
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleWindow.this.dispatchEvent(new WindowEvent(ConsoleWindow.this, 201));
            }
        });
    }

    static {
        maxLines = 1000;
        isFirstTime = true;
    }
}

