/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.StringTokenizer;

public class Utils {
    private static boolean isClassicMac;
    private static boolean isMacOSX;
    private static boolean isWindows;
    private static boolean isMSVM;
    private static boolean isJava2;
    private static boolean allowRaggedArrays;
    private static String jlinkJarDir;
    static /* synthetic */ Class class$com$wolfram$jlink$MathLink;

    public static boolean isPrimitiveArray(Class clazz) {
        Class clazz2 = Utils.getArrayComponentType(clazz);
        if (clazz2 == null) {
            return false;
        }
        return clazz2.isPrimitive();
    }

    public static Class getArrayComponentType(Class clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            return null;
        }
        if (clazz2.isArray()) {
            return Utils.getArrayComponentType(clazz2);
        }
        return clazz2;
    }

    public static int[] getArrayDims(Object object) {
        int n = 0;
        Class<?> clazz = object.getClass().getComponentType();
        while (clazz != null) {
            ++n;
            clazz = clazz.getComponentType();
        }
        int[] nArray = new int[n];
        Object object2 = object;
        int n2 = 0;
        while (n2 < n) {
            int n3 = Array.getLength(object2);
            if (n3 == 0) {
                int n4 = n2;
                while (n4 < n) {
                    nArray[n4] = 0;
                    ++n4;
                }
                break;
            }
            nArray[n2] = n3;
            object2 = Array.get(object2, 0);
            ++n2;
        }
        return nArray;
    }

    public static boolean isJava2OrLater() {
        return isJava2;
    }

    public static boolean isClassicMacintosh() {
        return isClassicMac;
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    public static boolean isMacintosh() {
        return Utils.isClassicMacintosh();
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isMicrosoftVM() {
        return isMSVM;
    }

    public static boolean isRaggedArrays() {
        return allowRaggedArrays;
    }

    public static void setRaggedArrays(boolean bl) {
        allowRaggedArrays = bl;
    }

    public static String determineLinkname(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (!string2.equals("-linkname") && !string2.equals("-linklaunch") || !stringTokenizer.hasMoreTokens()) continue;
            return stringTokenizer.nextToken();
        }
        return null;
    }

    public static String determineLinkname(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length - 1) {
                String string = stringArray[n].toLowerCase();
                if (string.equals("-linkname") || string.equals("-linklaunch")) {
                    return stringArray[n + 1];
                }
                ++n;
            }
        }
        return null;
    }

    public static String determineLinkmode(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (!string2.equals("-linkmode") || !stringTokenizer.hasMoreTokens()) continue;
            return stringTokenizer.nextToken().toLowerCase();
        }
        return null;
    }

    public static String determineLinkmode(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length - 1) {
                String string = stringArray[n].toLowerCase();
                if (string.equals("-linkmode")) {
                    return stringArray[n + 1].toLowerCase();
                }
                ++n;
            }
        }
        return null;
    }

    public static void writeEvalToStringExpression(MathLink mathLink, Object object, int n, boolean bl) throws MathLinkException {
        Utils.writeEvalToStringExpression(mathLink, object, n, bl ? "OutputForm" : "InputForm");
    }

    public static void writeEvalToStringExpression(MathLink mathLink, Object object, int n, String string) throws MathLinkException {
        mathLink.putFunction("EvaluatePacket", 1);
        mathLink.putFunction("ToString", 3);
        if (object instanceof String) {
            mathLink.putFunction("ToExpression", 1);
        }
        mathLink.put(object);
        mathLink.putFunction("Rule", 2);
        mathLink.putSymbol("FormatType");
        mathLink.putSymbol(string);
        mathLink.putFunction("Rule", 2);
        mathLink.putSymbol("PageWidth");
        if (n > 0) {
            mathLink.put(n);
        } else {
            mathLink.putSymbol("Infinity");
        }
        mathLink.endPacket();
    }

    public static void writeEvalToTypesetExpression(MathLink mathLink, Object object, int n, boolean bl) throws MathLinkException {
        mathLink.putFunction("EvaluatePacket", 1);
        int n2 = 1 + (bl ? 0 : 1) + (n > 0 ? 1 : 0);
        mathLink.putFunction("EvaluateToTypeset", n2);
        mathLink.put(object);
        if (!bl) {
            mathLink.putSymbol("TraditionalForm");
        }
        if (n > 0) {
            mathLink.put(n);
        }
        mathLink.endPacket();
    }

    public static void writeEvalToImageExpression(MathLink mathLink, Object object, int n, int n2, int n3, boolean bl) throws MathLinkException {
        mathLink.putFunction("EvaluatePacket", 1);
        int n4 = 1 + (bl ? 1 : 0) + (n3 > 0 ? 1 : 0) + (n > 0 || n2 > 0 ? 1 : 0);
        mathLink.putFunction("EvaluateToImage", n4);
        mathLink.put(object);
        if (bl) {
            mathLink.put(true);
        }
        if (n3 > 0) {
            mathLink.putFunction("Rule", 2);
            mathLink.putSymbol("ImageResolution");
            mathLink.put(n3);
        }
        if (n > 0 || n2 > 0) {
            mathLink.putFunction("Rule", 2);
            mathLink.putSymbol("ImageSize");
            mathLink.putFunction("List", 2);
            if (n > 0) {
                mathLink.put(n);
            } else {
                mathLink.putSymbol("Automatic");
            }
            if (n2 > 0) {
                mathLink.put(n2);
            } else {
                mathLink.putSymbol("Automatic");
            }
        }
        mathLink.endPacket();
    }

    public static String getJLinkVersion() {
        return "2.1.0";
    }

    public static BigDecimal bigDecimalFromString(String string) {
        int n;
        if (string.charAt(0) == '.') {
            string = "0" + string;
        }
        int n2 = string.length();
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        boolean bl2 = false;
        int n7 = 0;
        block0: while (n7 < n2) {
            n = byArray[n7];
            if (n >= 48 && n <= 57) {
                byArray2[n3++] = n;
            } else if (n == 45) {
                bl2 = true;
                byArray2[n3++] = n;
            } else {
                if (n != 46) {
                    if (n != 101) break;
                    n5 = n7++;
                    while (n7 < n2) {
                        if (byArray[n7] != 45 && (byArray[n7] < 48 || byArray[n7] > 57)) break block0;
                        ++n6;
                        ++n7;
                    }
                    break;
                }
                n4 = n7;
            }
            ++n7;
        }
        n = 0;
        String string2 = null;
        if (n4 == 0) {
            string2 = new String(byArray);
        } else if (n5 == 0) {
            string2 = new String(byArray2, 0, n3);
            n = n3 - n4;
        } else {
            String string3 = new String(byArray, n5 + 1, n6);
            int n8 = Integer.parseInt(string3);
            byte[] byArray3 = new byte[Math.max(n3, n8 + n4)];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            n7 = n3;
            while (n7 < byArray3.length) {
                byArray3[n7] = 48;
                ++n7;
            }
            string2 = new String(byArray3);
            n = Math.max(0, n5 - 1 - n4 - n8);
        }
        return new BigDecimal(new BigInteger(string2), n);
    }

    static String createExceptionMessage(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
        throwable.printStackTrace(printWriter);
        String string = stringWriter.toString();
        String string2 = new String();
        try {
            String string3;
            stringWriter.close();
            printWriter.close();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            boolean bl = false;
            string2 = string3 = bufferedReader.readLine();
            while ((string3 = bufferedReader.readLine()) != null) {
                boolean bl2;
                boolean bl3 = string3.indexOf("com.wolfram.jlink") != -1 || string3.indexOf("com/wolfram/jlink") != -1;
                boolean bl4 = bl2 = string3.indexOf("com.wolfram.jlink.Testing") != -1 || string3.indexOf("com/wolfram/jlink/Testing") != -1;
                if (string3.indexOf("java.lang.reflect.Method.invoke") != -1) {
                    bufferedReader.mark(1000);
                    String string4 = bufferedReader.readLine();
                    bufferedReader.reset();
                    if (string4 != null && (string4.indexOf("com.wolfram.jlink") != -1 || string4.indexOf("com/wolfram/jlink") != -1)) {
                        bl3 = true;
                    }
                }
                if (bl3 && !bl2) continue;
                string2 = string2 + "\n" + string3;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public static String[] getSystemID() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        if (File.separatorChar == '\\') {
            return new String[]{"Windows"};
        }
        if (Utils.isMacOSX()) {
            return new String[]{"Darwin"};
        }
        if (string2.equals("i386") || string2.equals("x86")) {
            return new String[]{"Linux"};
        }
        if (string2.equals("sparc")) {
            return new String[]{"Solaris", "UltraSPARC"};
        }
        if (string2.startsWith("PA_RISC") || string2.startsWith("PA-RISC")) {
            return new String[]{"HP-RISC", "HPUX-PA64"};
        }
        if (string2.equals("mips")) {
            return new String[]{"SGI"};
        }
        if (string2.equals("alpha")) {
            String[] stringArray;
            if (string.equals("Linux")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "Linux-AXP";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "DEC-AXP";
            }
            return stringArray;
        }
        if (string2.equals("ppc")) {
            String[] stringArray;
            if (string.equals("Linux")) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "Linux-PPC";
            } else {
                String[] stringArray5 = new String[2];
                stringArray5[0] = "IBM-RISC";
                stringArray = stringArray5;
                stringArray5[1] = "AIX-Power64";
            }
            return stringArray;
        }
        if (string2.equals("ia64") && string.equals("Linux")) {
            return new String[]{"Linux-IA64"};
        }
        return new String[]{""};
    }

    public static String getJLinkJarDir() {
        if (jlinkJarDir != null) {
            return jlinkJarDir;
        }
        String string = null;
        if (Utils.isJava2OrLater()) {
            String string2;
            URL uRL = null;
            try {
                uRL = (class$com$wolfram$jlink$MathLink == null ? (class$com$wolfram$jlink$MathLink = Utils.class$("com.wolfram.jlink.MathLink")) : class$com$wolfram$jlink$MathLink).getResource("/com/wolfram/jlink/NativeLink.class");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRL != null && (string2 = uRL.getFile()) != null && string2.startsWith("file:") && string2.indexOf("JLink.jar") != -1) {
                if (string2.indexOf("%20") != -1) {
                    String string3 = "";
                    int n = 0;
                    while (n < string2.length()) {
                        if (string2.charAt(n) == '%') {
                            string3 = string3 + " ";
                            n += 2;
                        } else {
                            string3 = string3 + string2.charAt(n);
                        }
                        ++n;
                    }
                    string2 = string3;
                }
                string = string2.substring(5, string2.indexOf("JLink.jar"));
            }
        } else {
            try {
                String string4 = System.getProperty("java.class.path");
                int n = string4.indexOf("JLink.jar");
                if (n != -1) {
                    String string5 = string4.substring(0, n);
                    int n2 = string5.lastIndexOf(File.pathSeparator);
                    string = string5.substring(n2 + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jlinkJarDir = string;
        return jlinkJarDir;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        try {
            string = System.getProperty("java.specification.version");
            isJava2 = string != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            string = System.getProperty("os.name");
            isClassicMac = !isJava2 && string != null && string.toLowerCase().indexOf("mac") == 0;
            isMacOSX = isJava2 && string != null && string.toLowerCase().indexOf("mac") == 0;
            isWindows = string != null && string.toLowerCase().startsWith("windows");
            String string2 = System.getProperty("java.vendor");
            isMSVM = string2 != null && string2.toLowerCase().indexOf("microsoft") >= 0;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            string = System.getProperty("JLINK_RAGGED_ARRAYS");
            allowRaggedArrays = string != null && string.toLowerCase().equals("true");
        }
        catch (SecurityException securityException) {
            allowRaggedArrays = false;
        }
        jlinkJarDir = null;
    }
}

