/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.ClassRecord;
import com.wolfram.jlink.InstanceCollection;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Vector;

public class ObjectHandler {
    protected InstanceCollection instanceCollection = new InstanceCollection();
    protected Vector classList = new Vector(50, 30);

    public synchronized Class classFromIndex(int n) {
        Object e = this.classList.elementAt(n);
        return e != null ? ((ClassRecord)e).getCls() : null;
    }

    public synchronized void putReference(MathLink mathLink, Object object, Class clazz) throws MathLinkException {
        this.putRef(mathLink, object, clazz, this.instanceCollection.keyOf(object));
    }

    public synchronized Object getObject(String string) {
        Object object = null;
        if (!string.equals("Null")) {
            long l = ObjectHandler.keyFromMmaSymbol(string);
            object = this.instanceCollection.get(l);
        }
        return object;
    }

    public synchronized int loadClass(String string, Object object) throws ClassNotFoundException, SecurityException {
        ClassRecord classRecord = new ClassRecord(string, object);
        int n = this.classList.size();
        this.classList.addElement(classRecord);
        return n;
    }

    public synchronized void putInfo(KernelLink kernelLink, int n, Object object) throws MathLinkException {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        long l = object == null ? 0L : this.instanceCollection.keyOf(object);
        classRecord.putInfo(kernelLink, n, l != 0L ? ObjectHandler.mmaSymbolFromKey(l) : "Null");
    }

    public synchronized Object callCtor(int n, int[] nArray, Object[] objectArray) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        return classRecord.callBestCtor(nArray, objectArray);
    }

    public synchronized Object callMethod(int n, Object object, int[] nArray, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        return classRecord.callBestMethod(nArray, object, objectArray);
    }

    public synchronized Object getField(int n, Object object, int n2) throws IllegalAccessException, IllegalArgumentException, NoSuchMethodException {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        return classRecord.callField(false, object, n2, null);
    }

    public synchronized void setField(int n, Object object, int n2, Object object2) throws IllegalAccessException, IllegalArgumentException, NoSuchMethodException {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        classRecord.callField(true, object, n2, object2);
    }

    public synchronized void releaseInstance(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            long l = ObjectHandler.keyFromMmaSymbol(stringArray[n]);
            this.instanceCollection.remove(l);
            ++n;
        }
    }

    public synchronized void releaseAllInstances(int n) {
        String string = ((ClassRecord)this.classList.elementAt(n)).getCls().getName();
        Long[] longArray = new Long[this.instanceCollection.size()];
        int n2 = 0;
        Enumeration enumeration = this.instanceCollection.keys();
        while (enumeration.hasMoreElements()) {
            longArray[n2++] = (Long)enumeration.nextElement();
        }
        while (--n2 >= 0) {
            Object object = this.instanceCollection.get(longArray[n2]);
            if (!object.getClass().getName().equals(string)) continue;
            this.instanceCollection.remove(longArray[n2]);
        }
    }

    public synchronized void unloadClass(int n) {
        this.classList.setElementAt(null, n);
    }

    public synchronized void callOnLoadClass(KernelLink kernelLink, int n) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        classRecord.callOnLoadClass(kernelLink);
    }

    public synchronized void callOnUnloadClass(KernelLink kernelLink, int n) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        classRecord.callOnUnloadClass(kernelLink);
    }

    public synchronized int reflect(MathLink mathLink, int n, int n2, boolean bl, boolean bl2) throws MathLinkException {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        return classRecord.reflect(mathLink, n2, bl, bl2);
    }

    public synchronized void peekObjects(MathLink mathLink) throws MathLinkException {
        mathLink.putFunction("List", this.instanceCollection.size());
        Enumeration enumeration = this.instanceCollection.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            Object object = this.instanceCollection.get(l);
            this.putRef(mathLink, object, null, l);
        }
        mathLink.endPacket();
    }

    public synchronized void peekClasses(MathLink mathLink) throws MathLinkException {
        int n = 0;
        int n2 = 0;
        while (n2 < this.classList.size()) {
            if (this.classList.elementAt(n2) != null) {
                ++n;
            }
            ++n2;
        }
        mathLink.putFunction("List", n);
        n2 = 0;
        while (n2 < this.classList.size()) {
            Object e = this.classList.elementAt(n2);
            if (e != null) {
                mathLink.put(n2);
            }
            ++n2;
        }
        mathLink.endPacket();
    }

    public synchronized String getComponentTypeName(int n) {
        ClassRecord classRecord = (ClassRecord)this.classList.elementAt(n);
        return Utils.getArrayComponentType(classRecord.getCls()).getName();
    }

    public synchronized void putRef(MathLink mathLink, Object object, Class clazz, long l) throws MathLinkException {
        Object object2;
        if (l != 0L) {
            mathLink.putSymbol(ObjectHandler.mmaSymbolFromKey(l));
            return;
        }
        l = this.instanceCollection.put(object);
        String string = ObjectHandler.mmaSymbolFromKey(l);
        Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
        int n = -1;
        int n2 = 0;
        while (n2 < this.classList.size()) {
            object2 = this.classList.elementAt(n2);
            if (object2 != null && clazz2.equals(((ClassRecord)object2).getCls())) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            object2 = clazz2.getName();
            mathLink.putFunction("JLink`Package`loadClassAndCreateInstanceDefs", 2);
            mathLink.put(object2);
            mathLink.putSymbol(string);
        } else {
            mathLink.putFunction("JLink`Package`createInstanceDefs", 2);
            mathLink.put(n);
            mathLink.putSymbol(string);
        }
    }

    private static long keyFromMmaSymbol(String string) {
        String string2 = string.substring(string.lastIndexOf(116) + 1);
        try {
            return Long.parseLong(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private static String mmaSymbolFromKey(long l) {
        return "JLink`Objects`JavaObject" + Long.toString(l);
    }
}

