/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.Expr;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.StdLink;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.Hashtable;

public abstract class MathListener
implements EventListener {
    private Hashtable handlers;
    private KernelLink ml;
    static /* synthetic */ Class class$java$lang$Object;

    public MathListener() {
        this(StdLink.getLink());
    }

    public MathListener(KernelLink kernelLink) {
        this.ml = kernelLink;
        this.setupEvents();
    }

    public MathListener(String[][] stringArray) {
        this();
        int n = 0;
        while (n < stringArray.length) {
            this.setHandler(stringArray[n][0], stringArray[n][1]);
            ++n;
        }
    }

    public boolean setHandler(String string, String string2) {
        if (this.handlers.containsKey(string)) {
            this.handlers.put(string, string2);
            return true;
        }
        this.ml.message("Java::nohndlr", new String[]{string, this.getClass().getName()});
        return false;
    }

    protected Expr callMathHandler(String string, Object[] objectArray) {
        return this.callMathHandler0(true, string, objectArray);
    }

    protected void callVoidMathHandler(String string, Object[] objectArray) {
        this.callMathHandler0(false, string, objectArray);
    }

    protected KernelLink getLink() {
        return this.ml;
    }

    protected String getHandler(String string) {
        return (String)this.handlers.get(string);
    }

    private void setupEvents() {
        this.handlers = new Hashtable(10);
        try {
            Method[] methodArray = this.getClass().getMethods();
            Method[] methodArray2 = (class$java$lang$Object == null ? (class$java$lang$Object = MathListener.class$("java.lang.Object")) : class$java$lang$Object).getMethods();
            String[] stringArray = new String[methodArray2.length];
            int n = 0;
            while (n < methodArray2.length) {
                stringArray[n] = methodArray2[n].getName();
                ++n;
            }
            int n2 = 0;
            while (n2 < methodArray.length) {
                boolean bl = true;
                String string = methodArray[n2].getName();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (string.equals(stringArray[n3])) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    this.handlers.put(string, "");
                }
                ++n2;
            }
        }
        catch (SecurityException securityException) {
            System.err.println("Warning: MathListener cannot establish event handler callbacks: " + securityException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expr callMathHandler0(boolean bl, String string, Object[] objectArray) {
        if (this.ml == null) {
            return null;
        }
        String string2 = (String)this.handlers.get(string);
        if (string2 == null) {
            System.err.println("Warning: calling MathListener.callMathHandler() with a method name that does not exist in the class. Method name is " + string + ". Class is " + this.getClass().getName());
            return null;
        }
        Expr expr = null;
        if (!string2.equals("")) {
            int n;
            int n2 = n = objectArray != null ? objectArray.length : 0;
            if (this.ml.equals(StdLink.getLink())) {
                StdLink.requestTransaction();
            }
            KernelLink kernelLink = this.ml;
            synchronized (kernelLink) {
                try {
                    this.ml.putFunction("EvaluatePacket", 1);
                    this.ml.putNext(70);
                    this.ml.putArgCount(n);
                    this.ml.putFunction("ToExpression", 1);
                    this.ml.put(string2);
                    int n3 = 0;
                    while (n3 < n) {
                        this.ml.put(objectArray[n3]);
                        ++n3;
                    }
                    this.ml.endPacket();
                    if (bl) {
                        this.ml.waitForAnswer();
                        expr = this.ml.getExpr();
                    } else {
                        this.ml.discardAnswer();
                    }
                }
                catch (MathLinkException mathLinkException) {
                    this.ml.clearError();
                    this.ml.newPacket();
                }
            }
        }
        return expr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

