/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkImplBase;
import com.wolfram.jlink.MsgHandlerRecord;
import com.wolfram.jlink.PacketArrivedEvent;
import com.wolfram.jlink.PacketListener;
import com.wolfram.jlink.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public abstract class MathLinkImpl
extends MathLinkImplBase {
    protected Method userYielder;
    protected Object yielderObject;
    protected Vector userMsgHandlers = new Vector(2, 1);
    private long timeoutMillis = 0L;
    private long startConnectTime = 0L;
    private boolean connectTimeoutExpired;
    protected Vector packetListeners;
    private Object packetListenerLock = new Object();
    protected Object yieldFunctionLock = new Object();
    protected Class complexClass;
    protected Constructor complexCtor;
    protected Method complexReMethod;
    protected Method complexImMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(long l) throws MathLinkException {
        this.setYieldFunction(null, this, "connectTimeoutYielder");
        this.timeoutMillis = l;
        this.connectTimeoutExpired = false;
        this.startConnectTime = System.currentTimeMillis();
        try {
            this.connect();
            Object var4_2 = null;
            this.setYieldFunction(null, null, null);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.setYieldFunction(null, null, null);
            throw throwable;
        }
        if (this.connectTimeoutExpired) {
            throw new MathLinkException(1005);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setYieldFunction(Class clazz, Object object, String string) {
        Object object2 = this.yieldFunctionLock;
        synchronized (object2) {
            block10: {
                this.userYielder = null;
                this.yielderObject = null;
                if (string == null) break block10;
                Method method = null;
                Class[] classArray = new Class[]{};
                Class<?> clazz2 = clazz != null ? clazz : object.getClass();
                try {
                    method = clazz2.getMethod(string, classArray);
                }
                catch (Exception exception) {
                    boolean bl = false;
                    return bl;
                }
                this.userYielder = method;
                this.yielderObject = object;
                if (Utils.isJava2OrLater() && !this.userYielder.isAccessible()) {
                    try {
                        this.userYielder.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        System.err.println("J/Link warning: The yield function " + string + " might not be called due to a security restriction. " + "See the documentation for the class java.lang.reflect.ReflectPermission. This problem might go away " + "if JLink.jar is loaded from the classpath instead of the jre/lib/ext directory.");
                        securityException.printStackTrace();
                    }
                }
            }
            return true;
        }
    }

    public synchronized boolean addMessageHandler(Class clazz, Object object, String string) {
        Method method = null;
        Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
        Class<?> clazz2 = clazz != null ? clazz : object.getClass();
        try {
            method = clazz2.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return false;
        }
        Enumeration enumeration = this.userMsgHandlers.elements();
        while (enumeration.hasMoreElements()) {
            MsgHandlerRecord msgHandlerRecord = (MsgHandlerRecord)enumeration.nextElement();
            if (!msgHandlerRecord.meth.equals(method)) continue;
            return true;
        }
        this.userMsgHandlers.addElement(new MsgHandlerRecord(object, method, string));
        if (Utils.isJava2OrLater() && !method.isAccessible()) {
            try {
                method.setAccessible(true);
            }
            catch (SecurityException securityException) {
                System.err.println("J/Link warning: The message handler " + string + " might not be called due to a security restriction. " + "See the documentation for the class java.lang.reflect.ReflectPermission. This problem might go away " + "if JLink.jar is loaded from the classpath instead of the jre/lib/ext directory.");
                securityException.printStackTrace();
            }
        }
        return true;
    }

    public synchronized boolean removeMessageHandler(String string) {
        int n = 0;
        while (n < this.userMsgHandlers.size()) {
            if (((MsgHandlerRecord)this.userMsgHandlers.elementAt((int)n)).methName.equals(string)) {
                this.userMsgHandlers.removeElementAt(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void messageCallback(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        int n3 = 0;
        while (n3 < this.userMsgHandlers.size()) {
            try {
                MsgHandlerRecord msgHandlerRecord = (MsgHandlerRecord)this.userMsgHandlers.elementAt(n3);
                msgHandlerRecord.meth.invoke(msgHandlerRecord.target, objectArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean yielderCallback() {
        Object object = this.yieldFunctionLock;
        synchronized (object) {
            block7: {
                Object object2 = null;
                if (this.userYielder != null) {
                    try {
                        object2 = this.userYielder.invoke(this.yielderObject, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!(object2 instanceof Boolean)) break block7;
                boolean bl = (Boolean)object2;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean connectTimeoutYielder() {
        this.connectTimeoutExpired = System.currentTimeMillis() > this.startConnectTime + this.timeoutMillis;
        return this.connectTimeoutExpired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketListener(PacketListener packetListener) {
        Object object = this.packetListenerLock;
        synchronized (object) {
            if (this.packetListeners == null) {
                this.packetListeners = new Vector(2, 2);
            }
            if (!this.packetListeners.contains(packetListener)) {
                this.packetListeners.addElement(packetListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketListener(PacketListener packetListener) {
        Object object = this.packetListenerLock;
        synchronized (object) {
            if (this.packetListeners != null && this.packetListeners.contains(packetListener)) {
                this.packetListeners.removeElement(packetListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean notifyPacketListeners(int n) {
        Vector vector;
        if (this.packetListeners == null) {
            return true;
        }
        boolean bl = true;
        PacketArrivedEvent packetArrivedEvent = new PacketArrivedEvent((KernelLink)((Object)this), n);
        Object object = this.packetListenerLock;
        synchronized (object) {
            vector = (Vector)this.packetListeners.clone();
        }
        long l = 0L;
        try {
            try {
                boolean bl2 = true;
                l = this.createMark();
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2 && bl) {
                    block13: {
                        Object var13_12;
                        try {
                            try {
                                bl2 = ((PacketListener)vector.elementAt(n3)).packetArrived(packetArrivedEvent);
                                bl = bl && bl2;
                            }
                            catch (MathLinkException mathLinkException) {
                                this.clearError();
                                var13_12 = null;
                                this.seekMark(l);
                                break block13;
                            }
                            var13_12 = null;
                        }
                        catch (Throwable throwable) {
                            var13_12 = null;
                            this.seekMark(l);
                            throw throwable;
                        }
                        this.seekMark(l);
                    }
                    ++n3;
                }
            }
            catch (MathLinkException mathLinkException) {
                this.clearError();
                Object var15_15 = null;
                if (l == 0L) return bl;
                this.destroyMark(l);
                return bl;
            }
            Object var15_14 = null;
            if (l == 0L) return bl;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (l == 0L) throw throwable;
            this.destroyMark(l);
            throw throwable;
        }
        this.destroyMark(l);
        return bl;
    }

    public synchronized boolean setComplexClass(Class clazz) {
        Constructor constructor = null;
        Method method = null;
        Method method2 = null;
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{Double.TYPE, Double.TYPE};
                constructor = clazz.getDeclaredConstructor(classArray);
                method = clazz.getDeclaredMethod("re", null);
                method2 = clazz.getDeclaredMethod("im", null);
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.complexClass = clazz;
        this.complexCtor = constructor;
        this.complexReMethod = method;
        this.complexImMethod = method2;
        return true;
    }

    public synchronized Class getComplexClass() {
        return this.complexClass;
    }

    protected synchronized Object constructComplex(double d, double d2) {
        Object[] objectArray = new Object[]{new Double(d), new Double(d2)};
        try {
            return this.complexCtor.newInstance(objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected synchronized double getRealPart(Object object) throws Exception {
        return (Double)this.complexReMethod.invoke(object, null);
    }

    protected synchronized double getImaginaryPart(Object object) throws Exception {
        return (Double)this.complexImMethod.invoke(object, null);
    }
}

