/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

public class MathLinkException
extends Exception {
    String msg;
    int code;
    Throwable wrappedException;

    public MathLinkException(int n, String string) {
        this.code = n;
        this.msg = string;
    }

    public MathLinkException(int n) {
        this.code = n;
        this.msg = MathLinkException.lookupMessageText(n);
    }

    public MathLinkException(Throwable throwable) {
        this(throwable, "");
    }

    public MathLinkException(Throwable throwable, String string) {
        this.code = 1006;
        this.wrappedException = throwable;
        String string2 = "";
        if (string.endsWith(".")) {
            string2 = " ";
        } else if (string.length() > 0) {
            string2 = ". ";
        }
        this.msg = string + string2 + "Was a wrapped exception. Original exception was: " + throwable.toString();
    }

    public int getErrCode() {
        return this.code;
    }

    public String getMessage() {
        return this.msg;
    }

    public Throwable getWrappedException() {
        return this.wrappedException;
    }

    public Throwable getCause() {
        return this.getWrappedException();
    }

    public String toString() {
        return "MathLinkException: " + String.valueOf(this.code) + ": " + this.msg;
    }

    static String lookupMessageText(int n) {
        String string = null;
        switch (n) {
            case 1002: {
                string = "Array is not as deep as requested.";
                break;
            }
            case 1003: {
                string = "Expression could not be read as a complex number.";
                break;
            }
            case 1005: {
                string = "The link was not connected before the requested time limit elapsed.";
                break;
            }
            case 1100: {
                string = "Expression on link is not a valid Java object reference.";
                break;
            }
            default: {
                string = "Extended error message not available.";
            }
        }
        return string;
    }
}

