/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Hashtable;

public class MathInvocationHandler
implements InvocationHandler {
    private Hashtable handlers = new Hashtable(20);
    private KernelLink ml;
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$wolfram$jlink$Expr;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public MathInvocationHandler() {
        this(StdLink.getLink());
    }

    public MathInvocationHandler(KernelLink kernelLink) {
        this.ml = kernelLink;
    }

    public MathInvocationHandler(String[][] stringArray) {
        this(StdLink.getLink(), stringArray);
    }

    public MathInvocationHandler(KernelLink kernelLink, String[][] stringArray) {
        this(kernelLink);
        int n = 0;
        while (n < stringArray.length) {
            this.setHandler(stringArray[n][0], stringArray[n][1]);
            ++n;
        }
    }

    public void setHandler(String string, String string2) {
        this.handlers.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        int n;
        String string;
        Object object2 = null;
        String string2 = method.getName();
        Class<?> clazz = method.getReturnType();
        if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object)) {
            if (method.equals(hashCodeMethod)) {
                return this.proxyHashCode(object);
            }
            if (method.equals(equalsMethod)) {
                return this.proxyEquals(object, objectArray[0]);
            }
            if (method.equals(toStringMethod)) {
                return this.proxyToString(object);
            }
        }
        if ((string = (String)this.handlers.get(string2)) == null) {
            return null;
        }
        int n2 = n = objectArray != null ? objectArray.length : 0;
        if (this.ml.equals(StdLink.getLink())) {
            StdLink.requestTransaction();
        }
        KernelLink kernelLink = this.ml;
        synchronized (kernelLink) {
            try {
                this.ml.putFunction("EvaluatePacket", 1);
                this.ml.putNext(70);
                this.ml.putArgCount(n);
                this.ml.putFunction("ToExpression", 1);
                this.ml.put(string);
                int n3 = 0;
                while (n3 < n) {
                    this.ml.put(objectArray[n3]);
                    ++n3;
                }
                this.ml.endPacket();
                this.ml.waitForAnswer();
                if (clazz.equals(class$com$wolfram$jlink$Expr == null ? (class$com$wolfram$jlink$Expr = MathInvocationHandler.class$("com.wolfram.jlink.Expr")) : class$com$wolfram$jlink$Expr)) {
                    object2 = this.ml.getExpr();
                } else {
                    switch (this.ml.getNext()) {
                        case 43: {
                            object2 = this.readAsInt(clazz, this.ml);
                            break;
                        }
                        case 42: {
                            object2 = this.readAsReal(clazz, this.ml);
                            break;
                        }
                        case 34: {
                            object2 = this.ml.getString();
                            break;
                        }
                        case 35: {
                            object2 = this.ml.getSymbol();
                            if (!object2.equals("Null")) break;
                            object2 = null;
                            break;
                        }
                        case 70: {
                            object2 = this.ml.getComplex();
                            break;
                        }
                        case 100000: {
                            object2 = this.ml.getObject();
                        }
                    }
                }
            }
            catch (MathLinkException mathLinkException) {
                this.ml.clearError();
                this.ml.newPacket();
                throw mathLinkException;
            }
        }
        return object2;
    }

    private Object readAsReal(Class clazz, KernelLink kernelLink) throws MathLinkException {
        if (clazz.equals(Double.TYPE)) {
            return new Double(kernelLink.getDouble());
        }
        if (clazz.equals(Float.TYPE)) {
            return new Float((float)kernelLink.getDouble());
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MathInvocationHandler.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return Utils.bigDecimalFromString(kernelLink.getString());
        }
        return null;
    }

    private Object readAsInt(Class clazz, KernelLink kernelLink) throws MathLinkException {
        if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MathInvocationHandler.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(kernelLink.getString());
        }
        long l = kernelLink.getLongInteger();
        if (clazz.equals(Character.TYPE)) {
            if (l >= 0L && l <= 65535L) {
                return new Character((char)l);
            }
            return new Long(l);
        }
        if (l >= -128L && l <= 127L) {
            return new Byte((byte)l);
        }
        if (l >= -32768L && l <= 32767L) {
            return new Short((short)l);
        }
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return new Integer((int)l);
        }
        return new Long(l);
    }

    protected Integer proxyHashCode(Object object) {
        return new Integer(System.identityHashCode(object));
    }

    protected Boolean proxyEquals(Object object, Object object2) {
        return object == object2 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object object) {
        return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            hashCodeMethod = (class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getMethod("hashCode", null);
            equalsMethod = (class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object);
            toStringMethod = (class$java$lang$Object == null ? (class$java$lang$Object = MathInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getMethod("toString", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }
}

