/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJQuitHandler;
import com.wolfram.jlink.JLinkSecurityManager;
import com.wolfram.jlink.MathFrame;
import com.wolfram.jlink.Utils;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MRJHandlers
implements MRJAboutHandler,
MRJQuitHandler {
    private MathFrame aboutFrame = new MathFrame("About J/Link");
    private MathFrame quitFrame = new MathFrame("Quit J/Link?");
    private MRJActionListener listener = new MRJActionListener();
    private Button okButton = new Button("OK");
    private Button quitButton = new Button("Quit");
    private Button dontQuitButton = new Button("Don't Quit");

    public static void setup() {
        MRJHandlers mRJHandlers = new MRJHandlers();
        if (MRJApplicationUtils.isMRJToolkitAvailable()) {
            MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)mRJHandlers);
            MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)mRJHandlers);
        }
    }

    private MRJHandlers() {
        this.aboutFrame.setResizable(false);
        ((Component)this.aboutFrame).setSize(370, 180);
        ((Component)this.aboutFrame).setLocation(200, 200);
        this.aboutFrame.setLayout(null);
        Label label = new Label("                           J/Link version " + Utils.getJLinkVersion());
        Label label2 = new Label("     Copyright (c) 1999-2002, Wolfram Research, Inc.");
        Label label3 = new Label("This program is launched and managed by Mathematica");
        Label label4 = new Label("to support calling Java code from Mathematica.");
        Font font = new Font("Dialog", 1, 12);
        label.setFont(font);
        label2.setFont(font);
        label3.setFont(font);
        label4.setFont(font);
        this.aboutFrame.add(label);
        this.aboutFrame.add(label2);
        this.aboutFrame.add(label3);
        this.aboutFrame.add(label4);
        this.aboutFrame.addNotify();
        Insets insets = this.aboutFrame.getInsets();
        Dimension dimension = this.aboutFrame.getSize();
        label.setBounds(insets.left + 10, insets.top + 20, 360, 20);
        label2.setBounds(insets.left + 10, insets.top + 40, 360, 20);
        label3.setBounds(insets.left + 10, insets.top + 80, 360, 20);
        label4.setBounds(insets.left + 10, insets.top + 100, 360, 20);
        this.okButton.addActionListener(this.listener);
        this.aboutFrame.add(this.okButton);
        this.okButton.setBounds((dimension.width - insets.left - insets.right - 60) / 2, dimension.height - 30, 60, 28);
        this.quitFrame.setResizable(false);
        ((Component)this.quitFrame).setSize(370, 180);
        ((Component)this.quitFrame).setLocation(200, 200);
        this.quitFrame.setLayout(null);
        Label label5 = new Label("This program is launched and managed by Mathematica");
        Label label6 = new Label("to support calling Java code from Mathematica.");
        Label label7 = new Label("It is intended to be closed by calling UninstallJava[].");
        Label label8 = new Label("You should not quit it manually unless you are sure you");
        Label label9 = new Label("need to do so.");
        label5.setFont(font);
        label6.setFont(font);
        label7.setFont(font);
        label8.setFont(font);
        label9.setFont(font);
        this.quitFrame.add(label5);
        this.quitFrame.add(label6);
        this.quitFrame.add(label7);
        this.quitFrame.add(label8);
        this.quitFrame.add(label9);
        this.quitFrame.addNotify();
        insets = this.quitFrame.getInsets();
        dimension = this.quitFrame.getSize();
        label5.setBounds(insets.left + 10, insets.top + 20, 360, 20);
        label6.setBounds(insets.left + 10, insets.top + 40, 360, 20);
        label7.setBounds(insets.left + 10, insets.top + 60, 360, 20);
        label8.setBounds(insets.left + 10, insets.top + 80, 360, 20);
        label9.setBounds(insets.left + 10, insets.top + 100, 360, 20);
        this.quitButton.addActionListener(this.listener);
        this.dontQuitButton.addActionListener(this.listener);
        this.quitFrame.add(this.dontQuitButton);
        this.quitFrame.add(this.quitButton);
        this.dontQuitButton.setBounds((dimension.width - insets.left - insets.right - 200) / 3, dimension.height - 30, 100, 28);
        this.quitButton.setBounds(100 + 2 * (dimension.width - insets.left - insets.right - 200) / 3, dimension.height - 30, 100, 28);
    }

    public void handleAbout() {
        ((Component)this.aboutFrame).setVisible(true);
        this.aboutFrame.toFront();
    }

    public void handleQuit() {
        ((Component)this.quitFrame).setVisible(true);
        this.quitFrame.toFront();
    }

    class MRJActionListener
    implements ActionListener {
        MRJActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MRJHandlers.this.okButton) {
                MRJHandlers.this.aboutFrame.dispose();
            } else if (object == MRJHandlers.this.dontQuitButton) {
                MRJHandlers.this.quitFrame.dispose();
            } else if (object == MRJHandlers.this.quitButton) {
                JLinkSecurityManager.setAllowExit(true);
                System.exit(0);
            }
        }
    }
}

