/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkSecurityManager;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import com.wolfram.jlink.NativeLink;
import com.wolfram.jlink.Reader;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.WrappedKernelLink;
import java.lang.reflect.Method;

public class Install {
    static final int CALLJAVA = 1;
    static final int LOADCLASS = 2;
    static final int THROW = 3;
    static final int GC = 4;
    static final int RELEASEOBJECT = 5;
    static final int RELEASEALLOBJECTS = 6;
    static final int UNLOADCLASS = 7;
    static final int VAL = 8;
    static final int ONLOADCLASS = 9;
    static final int ONUNLOADCLASS = 10;
    static final int SETCOMPLEX = 11;
    static final int GETCOMPLEX = 12;
    static final int REFLECT = 13;
    static final int SHOW = 14;
    static final int SAMEQ = 15;
    static final int INSTANCEOF = 16;
    static final int ALLOWRAGGED = 17;
    static final int GETEXCEPTION = 18;
    static final int CONNECTTOFE = 19;
    static final int DISCONNECTTOFE = 20;
    static final int PEEKCLASSES = 21;
    static final int PEEKOBJECTS = 22;
    static final int CLASSPATH = 23;
    static final int ADDTOCLASSPATH = 24;
    static final int SETSLEEP = 25;
    static final int ALLOWUICOMPUTATIONS = 26;
    static final int UITHREADWAITING = 27;
    static final int FORCEPOLLING = 28;
    static final int YIELDTIME = 29;
    static final int GETCONSOLE = 30;
    static final int COMQUERYINTERFACE = 31;
    static final int COMGETOBJECT = 32;

    public static void main(String[] stringArray) {
        MathLink mathLink;
        KernelLink kernelLink;
        System.out.println("J/Link (tm)");
        System.out.println("Copyright (C) 1999-2002, Wolfram Research, Inc. All Rights Reserved.");
        System.out.println("www.wolfram.com");
        System.out.println("Version 2.1.0");
        System.out.println("");
        System.out.flush();
        if (Utils.isClassicMacintosh()) {
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String string = null;
            try {
                string = System.getProperty("launch");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (!(stringArray.length != 0 || string != null && string.toLowerCase().equals("browse"))) {
                stringArray = new String[]{"launcher"};
            }
        }
        if (Utils.isMacOSX() || Utils.isClassicMacintosh()) {
            Object object;
            boolean bl = true;
            if (Utils.isMacOSX()) {
                object = null;
                try {
                    object = System.getProperty("com.wolfram.jlink.nogui");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (object != null && ((String)object).equals("true")) {
                    bl = false;
                }
            }
            if (bl) {
                try {
                    object = Class.forName("com.wolfram.jlink.MRJHandlers");
                    Method method = ((Class)object).getDeclaredMethod("setup", new Class[0]);
                    method.invoke(null, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Utils.isMacOSX()) {
                    NativeLink.loadNativeLibrary();
                    NativeLink.mathematicaToFront();
                }
            }
        }
        try {
            System.setSecurityManager(JLinkSecurityManager.getInstance());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            kernelLink = MathLinkFactory.createKernelLink(stringArray);
        }
        catch (MathLinkException mathLinkException) {
            System.err.println("FATAL ERROR: link creation failed.");
            return;
        }
        if (!Install.install(kernelLink)) {
            kernelLink.close();
            return;
        }
        if (Utils.isWindows() && kernelLink instanceof WrappedKernelLink && (mathLink = ((WrappedKernelLink)kernelLink).getMathLink()) instanceof NativeLink) {
            NativeLink cfr_ignored_0 = (NativeLink)mathLink;
            NativeLink.hideJavaWindow();
        }
        Reader.startReader(kernelLink, true, false);
    }

    public static KernelLink getStdLink() {
        return StdLink.getLink();
    }

    static boolean install(MathLink mathLink) {
        try {
            mathLink.connect();
            mathLink.put("Begin[\"JLink`Package`\"]");
            Install.definePattern(mathLink, "jCallJava[indices_List, argCount_Integer, args___]", "{indices, argCount, args}", 1);
            Install.definePattern(mathLink, "jLoadClass[class_String, objSupplyingClassLoader_Symbol, isComplexClass_]", "{class, objSupplyingClassLoader, isComplexClass}", 2);
            Install.definePattern(mathLink, "jThrow[exc_, msg_String]", "{exc, msg}", 3);
            Install.definePattern(mathLink, "jGC[]", "{}", 4);
            Install.definePattern(mathLink, "jReleaseObject[instances:{__Symbol}]", "{instances}", 5);
            Install.definePattern(mathLink, "jReleaseAllObjects[classIndex_Integer]", "{classIndex}", 6);
            Install.definePattern(mathLink, "jUnloadClass[classIndex_Integer]", "{classIndex}", 7);
            Install.definePattern(mathLink, "jVal[instance_Symbol]", "{instance}", 8);
            Install.definePattern(mathLink, "jOnLoadClass[classIndex_Integer]", "{classIndex}", 9);
            Install.definePattern(mathLink, "jOnUnloadClass[classIndex_Integer]", "{classIndex}", 10);
            Install.definePattern(mathLink, "jSetComplex[classIndex_Integer]", "{classIndex}", 11);
            Install.definePattern(mathLink, "jGetComplex[]", "{}", 12);
            Install.definePattern(mathLink, "jReflect[classIndex_Integer, type_Integer, inherited:(True | False)]", "{classIndex, type, inherited}", 13);
            Install.definePattern(mathLink, "jShow[wnd_Symbol]", "{wnd}", 14);
            Install.definePattern(mathLink, "jSameQ[obj1_Symbol, obj2_Symbol]", "{obj1, obj2}", 15);
            Install.definePattern(mathLink, "jInstanceOf[obj_Symbol, className_String]", "{obj, className}", 16);
            Install.definePattern(mathLink, "jAllowRaggedArrays[allow:(True | False)]", "{allow}", 17);
            Install.definePattern(mathLink, "jGetException[]", "{}", 18);
            Install.definePattern(mathLink, "jConnectToFEServer[linkName_String, protocol_String]", "{linkName, protocol}", 19);
            Install.definePattern(mathLink, "jDisconnectToFEServer[]", "{}", 20);
            Install.definePattern(mathLink, "jPeekClasses[]", "{}", 21);
            Install.definePattern(mathLink, "jPeekObjects[]", "{}", 22);
            Install.definePattern(mathLink, "jClassPath[]", "{}", 23);
            Install.definePattern(mathLink, "jAddToClassPath[dirs:{__String}, searchForJars:(True | False)]", "{dirs, searchForJars}", 24);
            Install.definePattern(mathLink, "jSetSleep[sleepInterval_Integer]", "{sleepInterval}", 25);
            Install.definePattern(mathLink, "jUIThreadWaitingQ[]", "{}", 27);
            Install.definePattern(mathLink, "jAllowUIComputations[allow:(True | False), enteringModal:(True | False):False]", "{allow, enteringModal}", 26);
            Install.definePattern(mathLink, "jForcePolling[force:(True | False), yielder:(True | False)]", "{force, yielder}", 28);
            Install.definePattern(mathLink, "jYieldTime[millis_Integer]", "{millis}", 29);
            Install.definePattern(mathLink, "jGetConsole[]", "{}", 30);
            Install.definePattern(mathLink, "jCOMQueryInterface[instance_Symbol, newIntf_String]", "{instance, newIntf}", 31);
            Install.definePattern(mathLink, "jCOMGetObject[obj_String, isGetActive:(True | False)]", "{obj, isGetActive}", 32);
            mathLink.put("End[]");
            mathLink.putSymbol("End");
            mathLink.flush();
            return true;
        }
        catch (MathLinkException mathLinkException) {
            return false;
        }
    }

    private static void definePattern(MathLink mathLink, String string, String string2, int n) throws MathLinkException {
        mathLink.putFunction("JLink`Package`jlinkDefineExternal", 3);
        mathLink.put(string);
        mathLink.put(string2);
        mathLink.put(n);
    }
}

