/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class SimpleCalculator
implements ActionListener {
    JFrame mainFrame = new JFrame("Very simple MuPAD-Shell");
    JPanel mainPanel;
    JTextField queryField;
    JLabel questionLabel;
    JLabel answerLabel;
    JButton calcButton;
    JButton returnButton;

    public static native String calcMuPAD(String var0);

    public static void center(Frame frame) {
        if (frame == null) {
            return;
        }
        Rectangle rectangle = frame.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
    }

    public SimpleCalculator() {
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SimpleCalculator.this.mainFrame.setVisible(false);
                SimpleCalculator.this.mainFrame.dispose();
            }
        });
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.mainPanel.setLayout(new GridLayout(4, 1));
        this.addWidgets();
        this.returnButton = new JButton("Back to the real MuPAD", new ImageIcon("cube.gif"));
        this.returnButton.setToolTipText("Click this button to return to MuPAD.");
        this.returnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleCalculator.this.mainFrame.setVisible(false);
                SimpleCalculator.this.mainFrame.dispose();
            }
        });
        this.mainFrame.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainFrame.getContentPane().add((Component)this.returnButton, "South");
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.mainFrame.toFront();
        SimpleCalculator.center(this.mainFrame);
    }

    public SimpleCalculator(String string) {
        this();
        this.queryField.setText(string);
    }

    private void addWidgets() {
        this.queryField = new JTextField(40);
        this.questionLabel = new JLabel("Please enter a query:", 2);
        this.calcButton = new JButton("Calculate...");
        this.calcButton.setToolTipText("Click this button to send a query to MuPAD.");
        this.answerLabel = new JLabel("MuPAD returned:", 2);
        this.calcButton.addActionListener(this);
        this.mainPanel.add(this.questionLabel);
        this.mainPanel.add(this.queryField);
        this.mainPanel.add(this.answerLabel);
        this.mainPanel.add(this.calcButton);
        this.questionLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.answerLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = SimpleCalculator.calcMuPAD(this.queryField.getText());
        this.answerLabel.setText("MuPAD returned: " + string);
        System.out.println("MuPAD calculated for " + this.queryField.getText() + ": " + string);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray.length == 0) {
            SimpleCalculator simpleCalculator = new SimpleCalculator();
        } else {
            SimpleCalculator simpleCalculator = new SimpleCalculator(stringArray[0]);
        }
    }
}

